<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class HistorialController extends Controller
{
    public function index()
    {
        return view("vistas/historial.index");
    }

    public function show(Request $request)
    {
        $request->validate([
            "txtdni" => "required",
        ]);

        $id_padre = DB::select(" select id_padre_familia from padre_familia where padre_dni = ?", [$request->txtdni]);
        if (count($id_padre) <= 0) {
            return response()->json([
                "message" => "No se encontro el padre de familia",
            ], 400);
        }

        $nombrePadreFamilia = DB::select("select concat(padre_nombres,' ',padre_ape_pat,' ', padre_ape_mat) as nombre from padre_familia where id_padre_familia=?", [$id_padre[0]->id_padre_familia]);

        $cantidadHijos = DB::select("SELECT COUNT(*) as cantidad FROM estudiante WHERE id_padre_familia=?", [$id_padre[0]->id_padre_familia]);
        $historialAportes = DB::select(
            "SELECT
            ap.id_aporte_padres,
            ap.id_aporte,
            ap.id_padre_familia,
            ap.monto_aportado,
            aporte.titulo,
            aporte.descripcion,
            aporte.monto,
            aporte.fecha,
            ap.monto_aporte,
            (ap.monto_aporte - monto_aportado) as debe
            FROM
            aporte_padres AS ap
            INNER JOIN aporte ON ap.id_aporte = aporte.id_aporte
            WHERE
                        ap.id_padre_familia = ?
            GROUP BY
                        ap.id_aporte_padres, ap.id_aporte, ap.id_padre_familia, aporte.titulo, aporte.descripcion, aporte.monto, aporte.fecha order by debe desc",
            [$id_padre[0]->id_padre_familia]
        );

        $historialReuniones = DB::select(
            " SELECT
            reunion_padres.*,
            reunion.titulo,
            reunion.id_estado_reunion,
            reunion.descripcion,
            reunion.multa_precio,
            reunion.fecha,
            reunion.hora,
            estado_reunion.estado
            FROM
            reunion_padres
            INNER JOIN reunion ON reunion_padres.id_reunion = reunion.id_reunion
            INNER JOIN estado_reunion ON reunion.id_estado_reunion = estado_reunion.id_estado_reunion        
            where id_padre_familia=?",
            [$id_padre[0]->id_padre_familia]
        );

        $historialPagos = DB::select("SELECT
        pago.*,
        usuario.nombres
        FROM
        pago
        INNER JOIN usuario ON pago.id_usuario = usuario.id_usuario where id_padre_familia=? order by fecha desc ", [$id_padre[0]->id_padre_familia]);


        return response()->json([
            "historialAportes" => $historialAportes,
            "historialReuniones" => $historialReuniones,
            "nombrePadreFamilia" => $nombrePadreFamilia[0]->nombre,
            "dni" => $request->txtdni,
            "cantidadHijos" => $cantidadHijos[0]->cantidad,
            "historialPagos" => $historialPagos
        ], 200);
    }

    public function descargaPDF($dni_padre)
    {
        // Validar que exista el padre de familia
        $padreExiste = DB::select("SELECT id_padre_familia FROM padre_familia WHERE padre_dni = ?", [$dni_padre]);
        if ($padreExiste == null) {
            return back()->with("INCORRECTO", "El padre de familia no existe");
        }

        // Consulta corregida para obtener datos del padre según la estructura de la BD
        $datosPadre = DB::select(
            "SELECT 
            p.id_padre_familia,
            p.padre_dni, 
            p.padre_nombres, 
            p.padre_ape_pat, 
            p.padre_ape_mat,
            CONCAT(p.padre_nombres,' ',p.padre_ape_pat,' ', p.padre_ape_mat) as nombre,
            p.celular,
            p.direccion,
            tc.nombre AS tipo_consanguinidad,
            c.nombre AS cargo,
            p.fecha_creacion,
            (SELECT COUNT(*) FROM estudiante WHERE id_padre_familia = p.id_padre_familia) as cantidad_hijos
        FROM 
            padre_familia p
        LEFT JOIN
            tipo_consanguinidad tc ON p.tipo_consanguinidad = tc.id_tipo_consanguinidad
        LEFT JOIN
            cargo c ON p.id_cargo = c.id_cargo
        WHERE 
            p.padre_dni = ?",
            [$dni_padre]
        );

        if (empty($datosPadre)) {
            return back()->with("INCORRECTO", "No se encontraron datos del padre");
        }

        $id_padre = $datosPadre[0]->id_padre_familia;
        $cantidadHijos = $datosPadre[0]->cantidad_hijos;

        // Obtenemos información de los hijos con la estructura correcta
        $hijos = DB::select(
            "SELECT 
            e.id_estudiante, 
            e.dni,
            e.nombres AS estudiante_nombres, 
            e.ape_pat AS estudiante_apellido_paterno,
            e.ape_mat AS estudiante_apellido_materno,
            CONCAT(e.nombres, ' ', e.ape_pat, ' ', e.ape_mat) AS nombre_completo,
            e.nivel,
            e.grado
        FROM 
            estudiante e
        WHERE 
            e.id_padre_familia = ?",
            [$id_padre]
        );

        // Historial de aportes
        $historialAportes = DB::select(
            "SELECT
            ap.id_aporte_padres,
            ap.id_aporte,
            ap.id_padre_familia,
            ap.monto_aportado,
            ap.monto_aporte,
            ap.debe,
            ap.comentario,
            a.titulo,
            a.descripcion,
            a.monto,
            a.fecha,
            a.multiplicar
            FROM
            aporte_padres AS ap
            INNER JOIN aporte a ON ap.id_aporte = a.id_aporte
            WHERE
            ap.id_padre_familia = ?
            ORDER BY a.fecha DESC",
            [$id_padre]
        );

        // Historial de reuniones
        $historialReuniones = DB::select(
            "SELECT
            rp.id_reunion_padres,
            rp.asistencia,
            rp.asistencia_salida,
            rp.detalles,
            r.titulo,
            r.id_estado_reunion,
            r.descripcion,
            r.multa_precio,
            r.fecha,
            r.hora,
            er.estado
            FROM
            reunion_padres rp
            INNER JOIN reunion r ON rp.id_reunion = r.id_reunion
            INNER JOIN estado_reunion er ON r.id_estado_reunion = er.id_estado_reunion
            WHERE rp.id_padre_familia = ?
            ORDER BY r.fecha DESC",
            [$id_padre]
        );

        // Historial de pagos
        $historialPagos = DB::select(
            "SELECT
        p.id_pago,
        p.id_padre_familia,
        p.id_usuario,
        p.pago_concepto,
        p.monto_pago,
        p.debe,
        p.fecha,
        p.fecha_pago_boucher,
        p.numero_pago_boucher,
        p.comentario,
        u.nombres,
        p.estado
        FROM
        pago p
        INNER JOIN usuario u ON p.id_usuario = u.id_usuario 
        WHERE p.id_padre_familia = ? 
        ORDER BY p.fecha DESC",
            [$id_padre]
        );

        $pdf = \App::make('dompdf.wrapper');
        $pdf->setPaper('A4', 'portrait');
        $pdf->loadView('vistas/historial.historialPDF', compact(
            "dni_padre",
            "datosPadre",
            "hijos",
            "historialAportes",
            "historialReuniones",
            "cantidadHijos",
            "historialPagos"
        ));
        return $pdf->stream("historial-$dni_padre.pdf");
    }
}
