<?php
// filepath: c:\laragon\www\SISTEMAS-INFORMACION\sis_apafa\app\Models\AportePadres.php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AportePadres extends Model
{
    use HasFactory;
    
    // Nombre de la tabla
    protected $table = 'aporte_padres';
    
    // Clave primaria
    protected $primaryKey = 'id_aporte_padres';
    
    // No usar timestamps
    public $timestamps = false;
    
    // Atributos asignables
    protected $fillable = [
        'id_aporte',
        'id_padre_familia',
        'monto_aporte',
        'monto_aportado',
        'debe',
        'comentario',
    ];
    
    // Relaciones
    public function aporte()
    {
        return $this->belongsTo(Aporte::class, 'id_aporte', 'id_aporte');
    }
    
    public function padreFamilia()
    {
        return $this->belongsTo(PadreFamilia::class, 'id_padre_familia', 'id_padre_familia');
    }
}