<?php
// filepath: c:\laragon\www\SISTEMAS-INFORMACION\sis_apafa\app\Models\PadreFamilia.php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PadreFamilia extends Model
{
    use HasFactory;
    
    protected $table = 'padre_familia';
    protected $primaryKey = 'id_padre_familia';
    public $timestamps = false;
    
    protected $fillable = [
        'id_cargo',
        'tipo_consanguinidad',
        'padre_dni',
        'padre_nombres',
        'padre_ape_pat',
        'padre_ape_mat',
        'celular',
        'direccion',
        'fecha_creacion'
    ];
    
    // Relaciones
    public function cargo()
    {
        return $this->belongsTo(Cargo::class, 'id_cargo', 'id_cargo');
    }
    
    public function tipoConsanguinidad()
    {
        return $this->belongsTo(TipoConsanguinidad::class, 'tipo_consanguinidad', 'id_tipo_consanguinidad');
    }
    
    public function estudiantes()
    {
        return $this->hasMany(Estudiante::class, 'id_padre_familia', 'id_padre_familia');
    }
    
    public function aportes()
    {
        return $this->belongsToMany(Aporte::class, 'aporte_padres', 'id_padre_familia', 'id_aporte')
                    ->withPivot('monto_aporte', 'monto_aportado', 'debe', 'comentario', 'fecha_pago_boucher', 'numero_pago_boucher');
    }
    
    public function aportePadres()
    {
        return $this->hasMany(AportePadres::class, 'id_padre_familia', 'id_padre_familia');
    }
    
    public function reuniones()
    {
        return $this->belongsToMany(Reunion::class, 'reunion_padres', 'id_padre_familia', 'id_reunion')
                    ->withPivot('asistencia', 'asistencia_salida', 'detalles');
    }
    
    public function reunionPadres()
    {
        return $this->hasMany(ReunionPadres::class, 'id_padre_familia', 'id_padre_familia');
    }
    
    public function pagos()
    {
        return $this->hasMany(Pago::class, 'id_padre_familia', 'id_padre_familia');
    }
}