<?php
// filepath: c:\laragon\www\SISTEMAS-INFORMACION\sis_apafa\app\Models\Pago.php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Pago extends Model
{
    use HasFactory;
    
    protected $table = 'pago';
    protected $primaryKey = 'id_pago';
    public $timestamps = false;
    
    protected $fillable = [
        'id_padre_familia',
        'id_usuario',
        'pago_concepto',
        'monto_pago',
        'debe',
        'fecha',
        'fecha_pago_boucher',
        'numero_pago_boucher',
        'foto_boucher',
        'comentario'
    ];
    
    // Relaciones
    public function padreFamilia()
    {
        return $this->belongsTo(PadreFamilia::class, 'id_padre_familia', 'id_padre_familia');
    }
    
    public function usuario()
    {
        return $this->belongsTo(Usuario::class, 'id_usuario', 'id_usuario');
    }
}