<?php
// filepath: c:\laragon\www\SISTEMAS-INFORMACION\sis_apafa\app\Models\Reunion.php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Reunion extends Model
{
    use HasFactory;
    
    protected $table = 'reunion';
    protected $primaryKey = 'id_reunion';
    public $timestamps = false;
    
    protected $fillable = [
        'id_estado_reunion',
        'titulo',
        'descripcion',
        'multa_precio',
        'fecha',
        'hora'
    ];
    
    // Relaciones
    public function estadoReunion()
    {
        return $this->belongsTo(EstadoReunion::class, 'id_estado_reunion', 'id_estado_reunion');
    }
    
    public function padresFamilia()
    {
        return $this->belongsToMany(PadreFamilia::class, 'reunion_padres', 'id_reunion', 'id_padre_familia')
                    ->withPivot('asistencia', 'asistencia_salida', 'detalles');
    }
    
    public function reunionPadres()
    {
        return $this->hasMany(ReunionPadres::class, 'id_reunion', 'id_reunion');
    }
}