<?php
// filepath: c:\laragon\www\SISTEMAS-INFORMACION\sis_apafa\app\Models\ReunionPadres.php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ReunionPadres extends Model
{
    use HasFactory;
    
    protected $table = 'reunion_padres';
    protected $primaryKey = 'id_reunion_padres';
    public $timestamps = false;
    
    protected $fillable = [
        'id_reunion',
        'id_padre_familia',
        'asistencia',
        'asistencia_salida',
        'detalles'
    ];
    
    // Relaciones
    public function reunion()
    {
        return $this->belongsTo(Reunion::class, 'id_reunion', 'id_reunion');
    }
    
    public function padreFamilia()
    {
        return $this->belongsTo(PadreFamilia::class, 'id_padre_familia', 'id_padre_familia');
    }
}