<?php
// filepath: c:\laragon\www\SISTEMAS-INFORMACION\sis_apafa\database\factories\AporteFactory.php
namespace Database\Factories;

use App\Models\Aporte;
use Illuminate\Database\Eloquent\Factories\Factory;

class AporteFactory extends Factory
{
    protected $model = Aporte::class;

    public function definition()
    {
        $conceptos = [
            'Cuota anual APAFA',
            'Mantenimiento de infraestructura',
            'Materiales educativos',
            'Actividades deportivas',
            'Festividades escolares',
            'Implementos tecnológicos',
            'Mejora de áreas verdes',
            'Capacitación docente',
            'Seguridad escolar',
            'Fondo de emergencia'
        ];

        return [
            'titulo' => $this->faker->randomElement($conceptos) . ' ' . date('Y'),
            'descripcion' => $this->faker->sentence(),
            'monto' => $this->faker->randomElement([20, 30, 50, 100, 150]),
            'fecha' => $this->faker->dateTimeBetween('-1 year', '+6 months'),
            'multiplicar' => $this->faker->randomElement(['si', 'no']),
            'rendicion' => $this->faker->word() . '.pdf'
        ];
    }
}
