<?php
// filepath: c:\laragon\www\SISTEMAS-INFORMACION\sis_apafa\database\factories\AportePadresFactory.php
namespace Database\Factories;

use App\Models\AportePadres;
use App\Models\Aporte;
use App\Models\PadreFamilia;
use Illuminate\Database\Eloquent\Factories\Factory;

class AportePadresFactory extends Factory
{
    protected $model = AportePadres::class;

    public function definition()
    {
        static $aporteIds = null;
        static $padreIds = null;
        
        if ($aporteIds === null) {
            $aporteIds = Aporte::pluck('id_aporte')->toArray();
        }
        
        if ($padreIds === null) {
            $padreIds = PadreFamilia::pluck('id_padre_familia')->toArray();
        }
        
        $aporte_id = $this->faker->randomElement($aporteIds);
        $montoAporte = Aporte::find($aporte_id)->monto;
        
        $pagado = $this->faker->boolean(70);
        $montoAportado = $pagado ? $montoAporte : $this->faker->numberBetween(0, $montoAporte - 1);
        $debe = $montoAporte - $montoAportado;
        
        return [
            'id_aporte' => $aporte_id,
            'id_padre_familia' => $this->faker->randomElement($padreIds),
            'monto_aporte' => $montoAporte,
            'monto_aportado' => $montoAportado,
            'debe' => $debe,
            'comentario' => $debe == 0 ? 'Pago completo' : 'Pendiente: ' . $debe,
        ];
    }
}