<?php
// filepath: c:\laragon\www\SISTEMAS-INFORMACION\sis_apafa\database\factories\EstudianteFactory.php
namespace Database\Factories;

use App\Models\Estudiante;
use App\Models\PadreFamilia;
use Illuminate\Database\Eloquent\Factories\Factory;

class EstudianteFactory extends Factory
{
    protected $model = Estudiante::class;

    public function definition()
    {
        static $padreIds = null;
        
        if ($padreIds === null) {
            $padreIds = PadreFamilia::pluck('id_padre_familia')->toArray();
        }
        
        $nivel = $this->faker->randomElement(['INICIAL', 'PRIMARIA', 'SECUNDARIA']);
        
        if ($nivel == 'INICIAL') {
            $grado = $this->faker->randomElement(['3 AÑOS', '4 AÑOS', '5 AÑOS']);
        } elseif ($nivel == 'PRIMARIA') {
            $grado = $this->faker->randomElement(['PRIMERO', 'SEGUNDO', 'TERCERO', 'CUARTO', 'QUINTO', 'SEXTO']);
        } else {
            $grado = $this->faker->randomElement(['PRIMERO', 'SEGUNDO', 'TERCERO', 'CUARTO', 'QUINTO']);
        }
        
        return [
            'id_padre_familia' => $this->faker->randomElement($padreIds),
            'dni' => $this->faker->unique()->numerify('########'),
            'nombres' => $this->faker->firstName,
            'ape_pat' => $this->faker->lastName,
            'ape_mat' => $this->faker->lastName,
            'nivel' => $nivel,
            'grado' => $grado
        ];
    }
}