<?php
// filepath: c:\laragon\www\SISTEMAS-INFORMACION\sis_apafa\database\factories\PadreFamiliaFactory.php
namespace Database\Factories;

use App\Models\PadreFamilia;
use App\Models\Cargo;
use App\Models\TipoConsanguinidad;
use Illuminate\Database\Eloquent\Factories\Factory;

class PadreFamiliaFactory extends Factory
{
    protected $model = PadreFamilia::class;

    public function definition()
    {
        // Obtenemos los IDs solo una vez, no en cada generación de registro
        static $cargoIds = null;
        static $tipoConsanguinidadIds = null;
        
        if ($cargoIds === null) {
            $cargoIds = Cargo::pluck('id_cargo')->toArray();
        }
        
        if ($tipoConsanguinidadIds === null) {
            $tipoConsanguinidadIds = TipoConsanguinidad::pluck('id_tipo_consanguinidad')->toArray();
        }
        
        return [
            'id_cargo' => $this->faker->randomElement($cargoIds),
            'tipo_consanguinidad' => $this->faker->randomElement($tipoConsanguinidadIds),
            'padre_dni' => $this->faker->unique()->numerify('########'),
            'padre_nombres' => $this->faker->firstName,
            'padre_ape_pat' => $this->faker->lastName,
            'padre_ape_mat' => $this->faker->lastName,
            'celular' => $this->faker->numerify('9########'),
            'direccion' => $this->faker->address,
            'fecha_creacion' => $this->faker->dateTimeBetween('-2 years', 'now')
        ];
    }
}