<?php
// filepath: c:\laragon\www\SISTEMAS-INFORMACION\sis_apafa\database\factories\UsuarioFactory.php
namespace Database\Factories;

use App\Models\Usuario;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Facades\Hash;

class UsuarioFactory extends Factory
{
    protected $model = Usuario::class;

    public function definition()
    {
        return [
            'nombres' => $this->faker->name,
            'usuario' => $this->faker->unique()->userName,
            'password' => Hash::make('password123'),
            'correo' => $this->faker->unique()->safeEmail,
            'estado' => 1,
            'codigo' => $this->faker->uuid
        ];
    }
}