<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('empresa', function (Blueprint $table) {
            $table->integer('id_empresa', true);
            $table->string('nombre', 100)->nullable();
            $table->string('cod_modular', 20)->nullable();
            $table->string('ubicacion', 100)->nullable();
            $table->string('telefono', 255)->nullable();
            $table->string('correo', 100)->nullable();
            $table->string('foto_institucion', 100)->nullable();
            $table->string('foto_ugel', 100)->nullable();
            $table->string('mapa_ubi', 255)->nullable();
            $table->text('mapa_ubi')->nullable();
        });
    }

    public function down()
    {
        Schema::dropIfExists('empresa');
    }
};