<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('aporte', function (Blueprint $table) {
            $table->integer('id_aporte', true);
            $table->string('titulo', 255)->nullable();
            $table->string('descripcion', 255)->nullable();
            $table->decimal('monto', 10, 0)->nullable();
            $table->dateTime('fecha')->nullable();
            $table->string('multiplicar', 255)->nullable();
            $table->string('rendicion', 255)->nullable();
        });
    }

    public function down()
    {
        Schema::dropIfExists('aporte');
    }
};