<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('aporte_padres', function (Blueprint $table) {
            $table->integer('id_aporte_padres', true);
            $table->integer('id_aporte')->nullable();
            $table->integer('id_padre_familia')->nullable();
            $table->decimal('monto_aporte', 10, 0)->nullable();
            $table->decimal('monto_aportado', 10, 0)->nullable();
            $table->decimal('debe', 10, 0)->nullable();
            $table->string('comentario', 255)->nullable();
            
            $table->foreign('id_aporte')
                ->references('id_aporte')
                ->on('aporte')
                ->onUpdate('cascade')
                ->onDelete('cascade');
                
            $table->foreign('id_padre_familia')
                ->references('id_padre_familia')
                ->on('padre_familia')
                ->onUpdate('cascade')
                ->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('aporte_padres');
    }
};