<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('pago', function (Blueprint $table) {
            $table->integer('id_pago', true);
            $table->integer('id_padre_familia')->nullable();
            $table->integer('id_usuario')->nullable();
            $table->string('pago_concepto', 255)->nullable();
            $table->decimal('monto_pago', 10, 0)->nullable();
            $table->decimal('debe', 10, 0)->nullable();
            $table->dateTime('fecha')->nullable()->useCurrent();
            $table->date('fecha_pago_boucher')->nullable();
            $table->string('numero_pago_boucher', 255)->nullable();
            $table->string('foto_boucher', 255)->nullable();
            $table->string('comentario', 255)->nullable();
            
            $table->foreign('id_padre_familia')
                ->references('id_padre_familia')
                ->on('padre_familia')
                ->onUpdate('cascade')
                ->onDelete('cascade');
                
            $table->foreign('id_usuario')
                ->references('id_usuario')
                ->on('usuario')
                ->onUpdate('set null')
                ->onDelete('set null');
        });
    }

    public function down()
    {
        Schema::dropIfExists('pago');
    }
};