<?php
// filepath: c:\laragon\www\SISTEMAS-INFORMACION\sis_apafa\database\seeders\DatabaseSeeder.php
namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Cargo;
use App\Models\TipoConsanguinidad;
use App\Models\EstadoReunion;
use App\Models\Empresa;
use App\Models\Usuario;
use App\Models\PadreFamilia;
use App\Models\Estudiante;
use App\Models\Aporte;
use App\Models\Reunion;
use App\Models\AportePadres;
use App\Models\ReunionPadres;
use App\Models\Pago;

class DatabaseSeeder extends Seeder
{
    public function run()
    {
        // Crear datos básicos primero
        Cargo::factory(8)->create();
        TipoConsanguinidad::factory(9)->create();
        EstadoReunion::factory(2)->create();
        Empresa::factory(1)->create();
        Usuario::factory(10)->create();
        
        // Crear un admin específico
        Usuario::factory()->create([
            'nombres' => 'Administrador',
            'usuario' => 'admin',
            'password' => bcrypt('admin123')
        ]);
        
        // Crear 3000 padres de familia (en bloques para mejor rendimiento)
        $this->command->info('Creando 3000 padres de familia...');
        $this->createInChunks(PadreFamilia::class, 3000);
        
        // Crear 3000 estudiantes
        $this->command->info('Creando 3000 estudiantes...');
        $this->createInChunks(Estudiante::class, 3000);
        
        // Crear aportes y reuniones
        $this->command->info('Creando aportes y reuniones...');
        Aporte::factory(20)->create();
        Reunion::factory(10)->activa()->create();
        Reunion::factory(20)->culminada()->create();
        
        // Crear relaciones (en cantidades menores para evitar sobrecarga)
        $this->command->info('Creando relaciones entre tablas...');
        $this->createInChunks(AportePadres::class, 500);
        $this->createInChunks(ReunionPadres::class, 500);
        $this->createInChunks(Pago::class, 200);
        
        $this->command->info('¡Base de datos poblada exitosamente!');
    }
    
    /**
     * Crea registros en bloques para mejorar rendimiento
     */
    private function createInChunks($model, $total, $chunkSize = 500)
    {
        $chunks = ceil($total / $chunkSize);
        
        for ($i = 0; $i < $chunks; $i++) {
            $count = min($chunkSize, $total - ($i * $chunkSize));
            $model::factory($count)->create();
            $this->command->info("Creados {$count} registros - Bloque " . ($i + 1) . "/{$chunks}");
        }
    }
}