@extends('layouts/app')
@section('titulo', 'Aporte')
@section('content')

    <style>
        .tab-content {
            padding: 20px;
            border: 1px solid #ddd;
            border-top: none;
            border-radius: 0 0 5px 5px;
            background-color: #fff;
        }

        .nav-tabs .nav-link {
            font-weight: 600;
            padding: 10px 20px;
        }

        .nav-tabs .nav-link.active {
            background-color: #f8f9fa;
            border-bottom-color: transparent;
        }

        .filtros-container {
            background-color: #f8f9fa;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 35px;
            /* Aumentado para dar más espacio entre los filtros y la tabla */
            border: 1px solid #e9ecef;
            padding-bottom: 15px;
            /* Padding adicional en la parte inferior */
        }

        .table thead th {
            background-color: #f2f2f2;
            font-weight: 600;
        }

        .table-pagados thead th {
            background-color: #d4edda;
        }

        .table-asignados-no-pagados thead th {
            background-color: #f8d7da;
        }

        .table-no-asignados thead th {
            background-color: #e2e3e5;
        }

        .actions-column {
            width: 120px;
        }

        .btn-sm {
            padding: 0.25rem 0.5rem;
            font-size: 0.75rem;
        }

        .contador-badge {
            font-size: 0.85rem;
            margin-left: 8px;
            vertical-align: middle;
        }

        /* Estilos para hacer clickeable el encabezado de selección */
        .select-header-text {
            cursor: pointer;
        }

        /* Centrar checkboxes en sus celdas */
        td input[type="checkbox"],
        th input[type="checkbox"] {
            display: block;
            margin: 0 auto;
        }

        /* Estilos para selects múltiples nativos - optimizados para scroll */
        select[multiple] {
            height: 150px;
            /* Altura más razonable que permite scrolling */
            border: 1px solid #ced4da;
            border-radius: 4px;
            padding: 5px;
            font-size: 14px;
            overflow-y: auto;
            /* Garantizar scroll vertical */
            scrollbar-width: thin;
            /* Para Firefox */
            scrollbar-color: #007bff #f8f9fa;
            /* Para Firefox */
        }

        /* Estilo para scrollbars en Chrome/Edge/Safari */
        select[multiple]::-webkit-scrollbar {
            width: 8px;
        }

        select[multiple]::-webkit-scrollbar-track {
            background: #f8f9fa;
            border-radius: 4px;
        }

        select[multiple]::-webkit-scrollbar-thumb {
            background-color: #007bff;
            border-radius: 4px;
            border: 2px solid #f8f9fa;
        }

        /* Ajuste para botones */
        .btn-filtrar {
            margin-top: 125px;
            /* Ajustado para la nueva altura del select */
        }

        /* Estilo para opciones del select */
        select[multiple] option {
            padding: 5px;
            margin-bottom: 2px;
            border-radius: 3px;
        }

        select[multiple] option:hover {
            background-color: #e9ecef;
        }

        /* Color negro para el texto de los badges de estado */
        .badge {
            color: #000 !important;
            font-weight: 500;
        }

        .badge-success {
            background-color: #d4edda;
            border: 1px solid #c3e6cb;
        }

        .badge-warning {
            background-color: #fff3cd;
            border: 1px solid #ffeeba;
        }

        .badge-secondary {
            background-color: #e2e3e5;
            border: 1px solid #d6d8db;
        }
    </style>

    <!-- Notificaciones y mensajes de sesión -->


    <!-- Notificaciones y mensajes de sesión -->
    @if (session('CORRECTO'))
        <script>
            $(function notificacion() {
                new PNotify({
                    title: "CORRECTO",
                    type: "success",
                    text: "{{ session('CORRECTO') }}",
                    styling: "bootstrap3"
                });
            });
        </script>
    @endif

    @if (session('INCORRECTO'))
        <script>
            $(function notificacion() {
                new PNotify({
                    title: "INCORRECTO",
                    type: "error",
                    text: "{{ session('INCORRECTO') }}",
                    styling: "bootstrap3"
                });
            });
        </script>
    @endif


    <div class="card">
        <div class="card-header text-white">
            <h4 class="text-center text-secondary pt-3">GESTIÓN DE PARTICIPANTES</h4>
        </div>
        <div class="card-body">
            <form action="{{ route('aportes.addParticipante') }}" method="POST" id="form">
                @csrf
                @foreach ($aporte as $itemAporte)
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h5 class="mb-0 text-primary font-weight-bold">{{ $itemAporte->titulo }}</h5>
                    </div>
                    <input type="hidden" name="txtidparticipante" id="txtidparticipante">
                    <input type="hidden" name="txtidaporte" value="{{ $itemAporte->id_aporte }}">
                    <input type="hidden" id="id_aporte_actual" value="{{ $itemAporte->id_aporte }}">
                @endforeach

                <!-- Contador de seleccionados -->
                <div class="alert alert-info mb-3">
                    <i class="fas fa-users mr-2"></i> <span id="contadorSeleccionados">0</span> padres seleccionados
                </div>

                <!-- Sistema de pestañas -->
                <ul class="nav nav-tabs mb-0" id="myTab" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" id="pagados-tab" data-toggle="tab" href="#pagados" role="tab">
                            <i class="fas fa-check-circle text-success mr-1"></i> Padres que pagaron
                            <span class="badge badge-success contador-badge" id="contador-pagados">0</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="no-pagados-tab" data-toggle="tab" href="#no-pagados" role="tab">
                            <i class="fas fa-exclamation-circle text-danger mr-1"></i> Padres asignados que no pagaron
                            <span class="badge badge-danger contador-badge" id="contador-no-pagados">0</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="no-asignados-tab" data-toggle="tab" href="#no-asignados" role="tab">
                            <i class="fas fa-user-plus text-primary mr-1"></i> Padres no asignados
                            <span class="badge badge-primary contador-badge" id="contador-no-asignados">0</span>
                        </a>
                    </li>
                </ul>

                <!-- Contenido de las pestañas -->
                <div class="tab-content" id="myTabContent">
                    <!-- Pestaña: Padres que pagaron -->
                    <div class="tab-pane fade show active in" id="pagados" role="tabpanel" aria-labelledby="pagados-tab">
                        <div class="filtros-container mb-4">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group mb-3">
                                        <label for="filtroNivelPagados" class="mb-2">
                                            <i class="fas fa-filter mr-1"></i> Filtrar por nivel:
                                            <small class="text-muted">(Use Ctrl+clic para seleccionar varios)</small>
                                        </label>
                                        <select id="filtroNivelPagados" class="form-control filtro-nivel"
                                            multiple="multiple">
                                            @foreach ($nivel as $n)
                                                <option value="{{ $n->nivel }}">{{ $n->nivel }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group mb-3">
                                        <label for="filtroGradoPagados" class="mb-2">
                                            <i class="fas fa-filter mr-1"></i> Filtrar por grado:
                                            <small class="text-muted">(Use Ctrl+clic para seleccionar varios)</small>
                                        </label>
                                        <select id="filtroGradoPagados" class="form-control filtro-grado"
                                            multiple="multiple">
                                            @foreach ($grado as $g)
                                                <option value="{{ $g->grado }}">{{ $g->grado }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4 d-flex align-items-end mb-3">
                                    <button type="button" class="btn btn-primary btn-block btn-aplicar-filtro"
                                        data-tabla="tablaPagados">
                                        <i class="fas fa-search mr-1"></i> Aplicar Filtros
                                    </button>
                                </div>
                            </div>
                        </div>

                        <div class="table-responsive">
                            <table id="tablaPagados" data-responsive-id="example"
                                class="display table table-striped table-pagados" cellspacing="0" width="100%">
                                <thead>
                                    <tr>
                                        <th class="text-center">Todos</th>
                                        <th>DNI</th>
                                        <th>Nombre del padre</th>
                                        <th>Nivel</th>
                                        <th>Grado</th>
                                        <th>Monto aporte</th>
                                        <th>Estado</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($padresFamilia as $item)
                                        @if ($item->esta_vinculado_en_reunion == 'si' && $item->ha_pagado == 'si')
                                            <tr>
                                                <td class="text-center">
                                                    <input type="checkbox"
                                                        data-idparticipante="{{ $item->id_padre_familia }}"
                                                        class="form-check select-item select-pagado" checked disabled>
                                                </td>
                                                <td>{{ $item->padre_dni }}</td>
                                                <td>{{ $item->padre_ape_pat }} {{ $item->padre_ape_mat }}
                                                    {{ $item->padre_nombres }}</td>
                                                <td>{{ $item->nivel ?? 'No asignado' }}</td>
                                                <td>{{ $item->grado ?? 'No asignado' }}</td>
                                                <td>S/. {{ $item->monto_aporte }}</td>
                                                <td><span class="badge badge-success">Pagado</span></td>
                                            </tr>
                                        @endif
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <!-- Pestaña: Padres asignados que no pagaron -->
                    <div class="tab-pane fade" id="no-pagados" role="tabpanel" aria-labelledby="no-pagados-tab">
                        <div class="filtros-container mb-4">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group mb-3">
                                        <label for="filtroNivelNoPagados" class="mb-2">
                                            <i class="fas fa-filter mr-1"></i> Filtrar por nivel:
                                            <small class="text-muted">(Use Ctrl+clic para seleccionar varios)</small>
                                        </label>
                                        <select id="filtroNivelNoPagados" class="form-control filtro-nivel"
                                            multiple="multiple">
                                            @foreach ($nivel as $n)
                                                <option value="{{ $n->nivel }}">{{ $n->nivel }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group mb-3">
                                        <label for="filtroGradoNoPagados" class="mb-2">
                                            <i class="fas fa-filter mr-1"></i> Filtrar por grado:
                                            <small class="text-muted">(Use Ctrl+clic para seleccionar varios)</small>
                                        </label>
                                        <select id="filtroGradoNoPagados" class="form-control filtro-grado"
                                            multiple="multiple">
                                            @foreach ($grado as $g)
                                                <option value="{{ $g->grado }}">{{ $g->grado }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4 d-flex align-items-end mb-3">
                                    <div class="row w-100">
                                        <div class="col-md-12">
                                            <button type="button" class="btn btn-primary btn-block btn-aplicar-filtro"
                                                data-tabla="tablaNoPagados">
                                                <i class="fas fa-search mr-1"></i> Aplicar
                                            </button>
                                            <button type="button" id="btnEliminarSeleccionados"
                                                class="btn btn-danger btn-block">
                                                <i class="fas fa-trash-alt mr-1"></i> Eliminar
                                            </button>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="table-responsive">
                            <table id="tablaNoPagados" data-responsive-id="example2"
                                class="display table table-striped table-asignados-no-pagados" cellspacing="0"
                                width="100%">
                                <thead>
                                    <tr>
                                        <th class="text-center">
                                            <span class="select-header-text" id="label-no-pagados">Todos</span>
                                            <input type="checkbox" class="form-check select-all" id="todosNoPagados">
                                        </th>
                                        <th>DNI</th>
                                        <th>Nombre del padre</th>
                                        <th>Nivel</th>
                                        <th>Grado</th>
                                        <th>Monto aporte</th>
                                        <th>Monto pagado</th>
                                        <th>Estado</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($padresFamilia as $item)
                                        @if ($item->esta_vinculado_en_reunion == 'si' && $item->ha_pagado == 'no')
                                            <tr>
                                                <td class="text-center">
                                                    <input type="checkbox"
                                                        data-idparticipante="{{ $item->id_padre_familia }}"
                                                        class="form-check select-item select-no-pagado">
                                                </td>
                                                <td>{{ $item->padre_dni }}</td>
                                                <td>{{ $item->padre_ape_pat }} {{ $item->padre_ape_mat }}
                                                    {{ $item->padre_nombres }}</td>
                                                <td>{{ $item->nivel ?? 'No asignado' }}</td>
                                                <td>{{ $item->grado ?? 'No asignado' }}</td>
                                                <td>S/. {{ $item->monto_aporte }}</td>
                                                <td>S/. {{ $item->monto_aportado ?? '0' }}</td>
                                                <td><span class="badge badge-warning">Pendiente</span></td>
                                            </tr>
                                        @endif
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <!-- Pestaña: Padres no asignados -->
                    <div class="tab-pane fade" id="no-asignados" role="tabpanel" aria-labelledby="no-asignados-tab">
                        <div class="filtros-container mb-4">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group mb-3">
                                        <label for="filtroNivelNoAsignados" class="mb-2">
                                            <i class="fas fa-filter mr-1"></i> Filtrar por nivel:
                                            <small class="text-muted">(Use Ctrl+clic para seleccionar varios)</small>
                                        </label>
                                        <select id="filtroNivelNoAsignados" class="form-control filtro-nivel"
                                            multiple="multiple">
                                            @foreach ($nivel as $n)
                                                <option value="{{ $n->nivel }}">{{ $n->nivel }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group mb-3">
                                        <label for="filtroGradoNoAsignados" class="mb-2">
                                            <i class="fas fa-filter mr-1"></i> Filtrar por grado:
                                            <small class="text-muted">(Use Ctrl+clic para seleccionar varios)</small>
                                        </label>
                                        <select id="filtroGradoNoAsignados" class="form-control filtro-grado"
                                            multiple="multiple">
                                            @foreach ($grado as $g)
                                                <option value="{{ $g->grado }}">{{ $g->grado }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4 d-flex align-items-end mb-3">
                                    <div class="row w-100">
                                        <div class="col-md-12">
                                            <button type="button" class="btn btn-primary btn-block btn-aplicar-filtro"
                                                data-tabla="tablaNoAsignados">
                                                <i class="fas fa-search mr-1"></i> Aplicar
                                            </button>
                                            <button type="button" id="btnGuardarSalir"
                                                class="btn btn-success btn-block">
                                                <i class="fas fa-plus-circle mr-1"></i> Agregar
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="table-responsive">
                            <table id="tablaNoAsignados" class="display table table-striped table-no-asignados"
                                cellspacing="0" width="100%">
                                <thead>
                                    <tr>
                                        <th class="text-center">
                                            <span class="select-header-text" id="label-no-asignados">Todos</span>
                                            <input type="checkbox" class="form-check select-all" id="todosNoAsignados">
                                        </th>
                                        <th>DNI</th>
                                        <th>Nombre del padre</th>
                                        <th>Nivel</th>
                                        <th>Grado</th>
                                        <th>Estado</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($padresFamilia as $item)
                                        @if ($item->esta_vinculado_en_reunion == 'no')
                                            <tr>
                                                <td class="text-center">
                                                    <input type="checkbox"
                                                        data-idparticipante="{{ $item->id_padre_familia }}"
                                                        class="form-check select-item select-no-asignado">
                                                </td>
                                                <td>{{ $item->padre_dni }}</td>
                                                <td>{{ $item->padre_ape_pat }} {{ $item->padre_ape_mat }}
                                                    {{ $item->padre_nombres }}</td>
                                                <td>{{ $item->nivel ?? 'No asignado' }}</td>
                                                <td>{{ $item->grado ?? 'No asignado' }}</td>
                                                <td><span class="badge badge-secondary">No asignado</span></td>
                                            </tr>
                                        @endif
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <script>
        $(document).ready(function() {
            // Variables para almacenar IDs seleccionados en todas las páginas
            var selectedNoAsignados = [];
            var selectedNoPagados = [];
            var selectedPagados = []; // Para los que ya pagaron (siempre incluidos)

            // Inicializar los padres que ya pagaron (siempre seleccionados)
            $('.select-pagado:disabled').each(function() {
                var id = $(this).data('idparticipante');
                if (id && !selectedPagados.includes(id)) {
                    selectedPagados.push(id);
                }
            });

            // Extensión para filtrar por nivel y grado en DataTables - modificada para multi-select
            $.fn.dataTable.ext.search.push(
                function(settings, data, dataIndex) {
                    var tableId = settings.nTable.id;
                    var nivelesSeleccionados = [];
                    var gradosSeleccionados = [];

                    // Seleccionar el filtro correcto según la tabla
                    if (tableId === 'tablaPagados') {
                        nivelesSeleccionados = $('#filtroNivelPagados').val() || [];
                        gradosSeleccionados = $('#filtroGradoPagados').val() || [];
                    } else if (tableId === 'tablaNoPagados') {
                        nivelesSeleccionados = $('#filtroNivelNoPagados').val() || [];
                        gradosSeleccionados = $('#filtroGradoNoPagados').val() || [];
                    } else if (tableId === 'tablaNoAsignados') {
                        nivelesSeleccionados = $('#filtroNivelNoAsignados').val() || [];
                        gradosSeleccionados = $('#filtroGradoNoAsignados').val() || [];
                    }

                    var nivel = data[3]; // Índice de la columna "Nivel"
                    var grado = data[4]; // Índice de la columna "Grado"

                    // Si no hay filtros, mostrar todas las filas
                    if (nivelesSeleccionados.length === 0 && gradosSeleccionados.length === 0) {
                        return true;
                    }

                    // Filtro por nivel
                    var pasaNivel = true;
                    if (nivelesSeleccionados.length > 0) {
                        pasaNivel = nivelesSeleccionados.some(function(n) {
                            return nivel.includes(n);
                        });
                    }

                    // Filtro por grado
                    var pasaGrado = true;
                    if (gradosSeleccionados.length > 0) {
                        pasaGrado = gradosSeleccionados.some(function(g) {
                            return grado.includes(g);
                        });
                    }

                    return pasaNivel && pasaGrado;
                }
            );

            // Inicializar DataTables con select en todas las páginas y columna de selección no ordenable
            var tablaPagados = $('#tablaPagados').DataTable({
                language: {
                    url: '//cdn.datatables.net/plug-ins/1.10.25/i18n/Spanish.json'
                },
                responsive: true,
                order: [
                    [2, 'asc']
                ],
                columnDefs: [{
                        orderable: false,
                        targets: 0
                    } // Deshabilita la ordenación en la primera columna
                ],
                drawCallback: function() {
                    // Actualizar estado de checkboxes según selecciones guardadas
                    $('.select-pagado', this.api().table().node()).each(function() {
                        var id = $(this).data('idparticipante');
                        if (selectedPagados.includes(id)) {
                            $(this).prop('checked', true);
                        }
                    });
                }
            });

            var tablaNoPagados = $('#tablaNoPagados').DataTable({
                language: {
                    url: '//cdn.datatables.net/plug-ins/1.10.25/i18n/Spanish.json'
                },
                responsive: true,
                order: [
                    [2, 'asc']
                ],
                columnDefs: [{
                        orderable: false,
                        targets: 0
                    } // Deshabilita la ordenación en la primera columna
                ],
                drawCallback: function() {
                    // Actualizar estado de checkboxes según selecciones guardadas
                    $('.select-no-pagado', this.api().table().node()).each(function() {
                        var id = $(this).data('idparticipante');
                        if (selectedNoPagados.includes(id)) {
                            $(this).prop('checked', true);
                        } else {
                            $(this).prop('checked', false);
                        }
                    });

                    // Actualizar el estado del checkbox "Seleccionar todos"
                    var allChecked = selectedNoPagados.length > 0;
                    $('.select-no-pagado:visible').each(function() {
                        if (!$(this).prop('checked')) {
                            allChecked = false;
                            return false; // Salir del each
                        }
                    });

                    $('#todosNoPagados').prop('checked', allChecked && $('.select-no-pagado:visible')
                        .length > 0);
                }
            });

            var tablaNoAsignados = $('#tablaNoAsignados').DataTable({
                language: {
                    url: '//cdn.datatables.net/plug-ins/1.10.25/i18n/Spanish.json'
                },
                responsive: true,
                order: [
                    [2, 'asc']
                ],
                columnDefs: [{
                        orderable: false,
                        targets: 0
                    } // Deshabilita la ordenación en la primera columna
                ],
                drawCallback: function() {
                    // Actualizar estado de checkboxes según selecciones guardadas
                    $('.select-no-asignado', this.api().table().node()).each(function() {
                        var id = $(this).data('idparticipante');
                        if (selectedNoAsignados.includes(id)) {
                            $(this).prop('checked', true);
                        } else {
                            $(this).prop('checked', false);
                        }
                    });

                    // Actualizar el estado del checkbox "Seleccionar todos"
                    var allChecked = true;
                    $('.select-no-asignado:visible').each(function() {
                        if (!$(this).prop('checked')) {
                            allChecked = false;
                            return false; // Salir del each
                        }
                    });

                    $('#todosNoAsignados').prop('checked', allChecked && $(
                        '.select-no-asignado:visible').length > 0);
                }
            });

            // Hacer que el texto "Seleccionar todos" active el checkbox
            $('#label-no-pagados').on('click', function() {
                $('#todosNoPagados').trigger('click');
            });

            $('#label-no-asignados').on('click', function() {
                $('#todosNoAsignados').trigger('click');
            });

            // Actualizar contadores de cada pestaña
            function actualizarContadoresPestanas() {
                $('#contador-pagados').text(tablaPagados.rows().count());
                $('#contador-no-pagados').text(tablaNoPagados.rows().count());
                $('#contador-no-asignados').text(tablaNoAsignados.rows().count());
            }

            // Aplicar filtros al hacer clic en el botón "Aplicar Filtros"
            $('.btn-aplicar-filtro').on('click', function() {
                var tablaId = $(this).data('tabla');

                switch (tablaId) {
                    case 'tablaPagados':
                        tablaPagados.draw();
                        break;
                    case 'tablaNoPagados':
                        tablaNoPagados.draw();
                        // Después de filtrar, actualizar estado del checkbox "Todos"
                        actualizarCheckboxTodos("todosNoPagados", ".select-no-pagado");
                        break;
                    case 'tablaNoAsignados':
                        tablaNoAsignados.draw();
                        // Después de filtrar, actualizar estado del checkbox "Todos"
                        actualizarCheckboxTodos("todosNoAsignados", ".select-no-asignado");
                        break;
                }
            });
            
            // Función para actualizar el estado del checkbox "Todos" basado en los elementos visibles
            function actualizarCheckboxTodos(checkboxId, selectorItems) {
                var allChecked = true;
                var visibleCount = 0;
                
                $(selectorItems + ':visible').each(function() {
                    visibleCount++;
                    if (!$(this).prop('checked')) {
                        allChecked = false;
                        return false;
                    }
                });
                
                // Sólo marcar como "todos seleccionados" si hay elementos visibles y todos están marcados
                $('#' + checkboxId).prop('checked', allChecked && visibleCount > 0);
            }

            // Manejar "Seleccionar todos" en tabla No Pagados
            $('#todosNoPagados').on('change', function() {
                var isChecked = $(this).prop('checked');

                // Primero actualizar UI para feedback inmediato
                $('.select-no-pagado:visible').prop('checked', isChecked);
                
                // Luego actualizar el array de selecciones según los registros visibles
                tablaNoPagados.rows({search: 'applied'}).every(function(rowIdx) {
                    var data = this.node();
                    var checkbox = $(data).find('.select-no-pagado');
                    var id = checkbox.data('idparticipante');
                    
                    if (isChecked) {
                        // Agregar solo si no existe ya en el array
                        if (id && !selectedNoPagados.includes(id)) {
                            selectedNoPagados.push(id);
                        }
                    } else {
                        // Remover ID cuando se desmarca
                        selectedNoPagados = selectedNoPagados.filter(item => item !== id);
                    }
                    // Actualizar visualmente el checkbox según corresponda
                    checkbox.prop('checked', isChecked);
                });

                actualizarContador();
            });

            // Manejar "Seleccionar todos" en tabla No Asignados
            $('#todosNoAsignados').on('change', function() {
                var isChecked = $(this).prop('checked');

                // Primero actualizar UI para feedback inmediato
                $('.select-no-asignado:visible').prop('checked', isChecked);
                
                // Luego actualizar el array de selecciones según los registros visibles
                tablaNoAsignados.rows({search: 'applied'}).every(function(rowIdx) {
                    var data = this.node();
                    var checkbox = $(data).find('.select-no-asignado');
                    var id = checkbox.data('idparticipante');
                    
                    if (isChecked) {
                        // Agregar solo si no existe ya en el array
                        if (id && !selectedNoAsignados.includes(id)) {
                            selectedNoAsignados.push(id);
                        }
                    } else {
                        // Remover ID cuando se desmarca
                        selectedNoAsignados = selectedNoAsignados.filter(item => item !== id);
                    }
                    // Actualizar visualmente el checkbox según corresponda
                    checkbox.prop('checked', isChecked);
                });

                actualizarContador();
            });

            // Manejar selecciones individuales en tabla No Pagados
            $(document).on('change', '.select-no-pagado', function() {
                var id = $(this).data('idparticipante');

                if ($(this).prop('checked') && !selectedNoPagados.includes(id)) {
                    selectedNoPagados.push(id);
                } else if (!$(this).prop('checked')) {
                    selectedNoPagados = selectedNoPagados.filter(item => item !== id);
                }

                actualizarContador();

                // Actualizar el estado del checkbox "Seleccionar todos"
                var allChecked = true;
                $('.select-no-pagado:visible').each(function() {
                    if (!$(this).prop('checked')) {
                        allChecked = false;
                        return false; // Salir del each
                    }
                });

                $('#todosNoPagados').prop('checked', allChecked);
            });

            // Manejar selecciones individuales en tabla No Asignados
            $(document).on('change', '.select-no-asignado', function() {
                var id = $(this).data('idparticipante');

                if ($(this).prop('checked') && !selectedNoAsignados.includes(id)) {
                    selectedNoAsignados.push(id);
                } else if (!$(this).prop('checked')) {
                    selectedNoAsignados = selectedNoAsignados.filter(item => item !== id);
                }

                actualizarContador();

                // Actualizar el estado del checkbox "Seleccionar todos"
                var allChecked = true;
                $('.select-no-asignado:visible').each(function() {
                    if (!$(this).prop('checked')) {
                        allChecked = false;
                        return false; // Salir del each
                    }
                });

                $('#todosNoAsignados').prop('checked', allChecked);
            });

            // Función para actualizar contador de seleccionados
            function actualizarContador() {
                var total = selectedNoPagados.length + selectedNoAsignados.length;
                $('#contadorSeleccionados').text(total);
            }

            // Acción para agregar un padre individual (botón "Agregar")
            $(document).on('click', '.agregar-padre', function() {
                var id = $(this).data('id');
                if (!selectedNoAsignados.includes(id)) {
                    selectedNoAsignados.push(id);
                }
                $(this).closest('tr').find('.select-item').prop('checked', true);
                actualizarContador();
            });

            // Acción para quitar un padre individual (botón "Quitar")
            $(document).on('click', '.quitar-padre', function() {
                var id = $(this).data('id');
                selectedNoPagados = selectedNoPagados.filter(item => item !== id);
                $(this).closest('tr').find('.select-item').prop('checked', false);
                actualizarContador();
            });

            // Inicializar contador y contadores de pestañas
            actualizarContador();
            actualizarContadoresPestanas();

            // Asegurarse de que se actualicen los contadores al cargar la página
            setTimeout(function() {
                actualizarContadoresPestanas();
            }, 500);

            // Manejar click en botón eliminar seleccionados
            $('#btnEliminarSeleccionados').click(function() {
                // Validar que haya seleccionado al menos un padre
                if (selectedNoPagados.length === 0) {
                    new PNotify({
                        title: "ADVERTENCIA",
                        type: "warning",
                        text: "Debe seleccionar al menos un padre para eliminar",
                        styling: "bootstrap3"
                    });
                    return;
                }

                // Confirmar la eliminación
                if (confirm('¿Está seguro de eliminar los ' + selectedNoPagados.length +
                        ' padres seleccionados?')) {
                    if (confirm('Esta acción no se puede deshacer. ¿Desea continuar?')) {
                        // Obtener el ID del aporte actual
                        var idAporte = $('#id_aporte_actual').val();

                        // Crear un formulario dinámico para enviar por POST
                        var form = $('<form>', {
                            'method': 'POST',
                            'action': '{{ url('aportes/eliminarParticipanteSeleccionados') }}/' +
                                idAporte
                        });

                        // Agregar token CSRF para Laravel
                        form.append($('<input>', {
                            'type': 'hidden',
                            'name': '_token',
                            'value': '{{ csrf_token() }}'
                        }));

                        // Agregar los IDs como campo oculto
                        form.append($('<input>', {
                            'type': 'hidden',
                            'name': 'padres_seleccionados',
                            'value': selectedNoPagados.join(',')
                        }));

                        // Añadir al documento, enviar y eliminar
                        $('body').append(form);
                        form.submit();
                    }
                }
            });

            // Manejar click en botón agregar
            $('#btnGuardarSalir').click(function(e) {
                e.preventDefault();

                // Verificar si estamos en la pestaña de "no-asignados"
                if ($('#no-asignados-tab').hasClass('active') && selectedNoAsignados.length === 0) {
                    new PNotify({
                        title: "ADVERTENCIA",
                        type: "warning",
                        text: "Debe seleccionar al menos un padre de familia de la tabla NO ASIGNADOS",
                        styling: "bootstrap3"
                    });
                    return;
                }

                // Combinar todas las selecciones
                var selectedParticipants = [...selectedNoPagados, ...selectedNoAsignados, ...
                    selectedPagados
                ];

                // Eliminar posibles duplicados
                selectedParticipants = [...new Set(selectedParticipants)];

                // Validar que haya al menos un participante seleccionado
                if (selectedParticipants.length === 0) {
                    new PNotify({
                        title: "ADVERTENCIA",
                        type: "warning",
                        text: "Debe seleccionar al menos un padre de familia",
                        styling: "bootstrap3"
                    });
                    return;
                }

                // Establecer los ID de los participantes en el campo oculto del formulario
                $('#txtidparticipante').val(selectedParticipants.join(','));
                console.log(selectedParticipants.length + ' participantes seleccionados');

                // Enviar el formulario
                $('#form').submit();
            });

            // Add tab change event to refresh responsive calculations
            $('a[data-toggle="tab"]').on('shown.bs.tab', function(e) {
                // This will recalculate DataTables responsive layouts when switching tabs
                setTimeout(function() {
                    $($.fn.dataTable.tables(true)).DataTable().responsive.recalc();
                }, 10);
            });

            // Después de cada redibujado de las tablas, actualizar estado de checkboxes
            tablaNoPagados.on('draw', function() {
                // Actualizar estado de cada checkbox basado en su ID
                $('.select-no-pagado').each(function() {
                    var id = $(this).data('idparticipante');
                    $(this).prop('checked', selectedNoPagados.includes(id));
                });
                
                // Actualizar estado del checkbox "Todos"
                actualizarCheckboxTodos("todosNoPagados", ".select-no-pagado");
            });
            
            tablaNoAsignados.on('draw', function() {
                // Actualizar estado de cada checkbox basado en su ID
                $('.select-no-asignado').each(function() {
                    var id = $(this).data('idparticipante');
                    $(this).prop('checked', selectedNoAsignados.includes(id));
                });
                
                // Actualizar estado del checkbox "Todos"
                actualizarCheckboxTodos("todosNoAsignados", ".select-no-asignado");
            });
        });
    </script>
@endsection
