@extends('layouts/app')
@section('titulo', 'Reuniones')
@section('content')

    <style>
        .tab-content {
            padding: 20px;
            border: 1px solid #ddd;
            border-top: none;
            border-radius: 0 0 5px 5px;
            background-color: #fff;
        }

        .nav-tabs .nav-link {
            font-weight: 600;
            padding: 10px 20px;
        }

        .nav-tabs .nav-link.active {
            background-color: #f8f9fa;
            border-bottom-color: transparent;
        }

        .filtros-container {
            background-color: #f8f9fa;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 35px;
            border: 1px solid #e9ecef;
            padding-bottom: 15px;
        }

        .table thead th {
            background-color: #f2f2f2;
            font-weight: 600;
        }

        .table-asistentes thead th {
            background-color: #d4edda;
        }

        .table-no-asistentes thead th {
            background-color: #f8d7da;
        }

        .table-no-asignados thead th {
            background-color: #e2e3e5;
        }

        .actions-column {
            width: 120px;
        }

        .btn-sm {
            padding: 0.25rem 0.5rem;
            font-size: 0.75rem;
        }

        .contador-badge {
            font-size: 0.85rem;
            margin-left: 8px;
            vertical-align: middle;
        }

        /* Estilos para hacer clickeable el encabezado de selección */
        .select-header-text {
            cursor: pointer;
        }

        /* Centrar checkboxes en sus celdas */
        td input[type="checkbox"],
        th input[type="checkbox"] {
            display: block;
            margin: 0 auto;
        }

        /* Estilos para selects múltiples nativos - optimizados para scroll */
        select[multiple] {
            height: 150px;
            border: 1px solid #ced4da;
            border-radius: 4px;
            padding: 5px;
            font-size: 14px;
            overflow-y: auto;
            scrollbar-width: thin;
            scrollbar-color: #007bff #f8f9fa;
        }

        /* Estilo para scrollbars en Chrome/Edge/Safari */
        select[multiple]::-webkit-scrollbar {
            width: 8px;
        }

        select[multiple]::-webkit-scrollbar-track {
            background: #f8f9fa;
            border-radius: 4px;
        }

        select[multiple]::-webkit-scrollbar-thumb {
            background-color: #007bff;
            border-radius: 4px;
            border: 2px solid #f8f9fa;
        }

        /* Estilos adicionales de Aportes para opciones del select */
        select[multiple] option {
            padding: 5px;
            margin-bottom: 2px;
            border-radius: 3px;
        }

        select[multiple] option:hover {
            background-color: #e9ecef;
        }

        /* Estilos para los badges (igual a Aportes) */
        .badge {
            color: #000 !important;
            font-weight: 500;
        }

        .badge-success {
            background-color: #d4edda;
            border: 1px solid #c3e6cb;
        }

        .badge-warning {
            background-color: #fff3cd;
            border: 1px solid #ffeeba;
        }

        .badge-secondary {
            background-color: #e2e3e5;
            border: 1px solid #d6d8db;
        }

        /* Ajuste para botones */
        .btn-filtrar {
            margin-top: 125px;
        }

        /* Destacar el botón cuando hay selecciones */
        #btnGuardarSalir.seleccion-activa {
            animation: pulse 1.5s infinite;
        }

        @keyframes pulse {
            0% {
                box-shadow: 0 0 0 0 rgba(40, 167, 69, 0.7);
            }

            70% {
                box-shadow: 0 0 0 10px rgba(40, 167, 69, 0);
            }

            100% {
                box-shadow: 0 0 0 0 rgba(40, 167, 69, 0);
            }
        }

        #btnGuardarSalir:disabled {
            cursor: not-allowed;
            opacity: 0.7;
        }
    </style>

    <!-- Notificaciones y mensajes de sesión -->
    @if (session('CORRECTO'))
        <script>
            $(function notificacion() {
                new PNotify({
                    title: "CORRECTO",
                    type: "success",
                    text: "{{ session('CORRECTO') }}",
                    styling: "bootstrap3"
                });
            });
        </script>
    @endif

    @if (session('INCORRECTO'))
        <script>
            $(function notificacion() {
                new PNotify({
                    title: "INCORRECTO",
                    type: "error",
                    text: "{{ session('INCORRECTO') }}",
                    styling: "bootstrap3"
                });
            });
        </script>
    @endif

    <div class="card">
        <div class="card-header text-white">
            <h4 class="text-center text-secondary pt-3">GESTIÓN DE PARTICIPANTES</h4>
        </div>
        <div class="card-body">
            <form action="{{ route('reuniones.addParticipante') }}" method="POST" id="form">
                @csrf
                @foreach ($reunion as $itemReunion)
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h5 class="mb-0 text-primary font-weight-bold">{{ $itemReunion->titulo }}</h5>
                    </div>
                    <input type="hidden" name="txtidparticipante" id="txtidparticipante">
                    <input type="hidden" name="txtidreunion" value="{{ $itemReunion->id_reunion }}">
                    <input type="hidden" id="id_reunion_actual" value="{{ $itemReunion->id_reunion }}">
                @endforeach

                <!-- Contador de seleccionados -->
                <div class="alert alert-info mb-3">
                    <i class="fas fa-users mr-2"></i> <span id="contadorSeleccionados">0</span> padres seleccionados
                </div>

                <!-- Sistema de pestañas -->
                <ul class="nav nav-tabs mb-0" id="myTab" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" id="asistentes-tab" data-toggle="tab" href="#asistentes" role="tab">
                            <i class="fas fa-check-circle text-success mr-1"></i> Padres asistentes
                            <span class="badge badge-success contador-badge" id="contador-asistentes">0</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="no-asistentes-tab" data-toggle="tab" href="#no-asistentes" role="tab">
                            <i class="fas fa-exclamation-circle text-danger mr-1"></i> Padres asignados no asistentes
                            <span class="badge badge-danger contador-badge" id="contador-no-asistentes">0</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="no-asignados-tab" data-toggle="tab" href="#no-asignados" role="tab">
                            <i class="fas fa-user-plus text-primary mr-1"></i> Padres no asignados
                            <span class="badge badge-primary contador-badge" id="contador-no-asignados">0</span>
                        </a>
                    </li>
                </ul>

                <!-- Contenido de las pestañas -->
                <div class="tab-content" id="myTabContent">
                    <!-- Pestaña: Padres asistentes -->
                    <div class="tab-pane fade show active in" id="asistentes" role="tabpanel"
                        aria-labelledby="asistentes-tab">
                        <div class="filtros-container mb-4">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group mb-3">
                                        <label for="filtroNivelAsistentes" class="mb-2">
                                            <i class="fas fa-filter mr-1"></i> Filtrar por nivel:
                                            <small class="text-muted">(Use Ctrl+clic para seleccionar varios)</small>
                                        </label>
                                        <select id="filtroNivelAsistentes" class="form-control filtro-nivel"
                                            multiple="multiple">
                                            @foreach ($nivel as $n)
                                                <option value="{{ $n->nivel }}">{{ $n->nivel }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group mb-3">
                                        <label for="filtroGradoAsistentes" class="mb-2">
                                            <i class="fas fa-filter mr-1"></i> Filtrar por grado:
                                            <small class="text-muted">(Use Ctrl+clic para seleccionar varios)</small>
                                        </label>
                                        <select id="filtroGradoAsistentes" class="form-control filtro-grado"
                                            multiple="multiple">
                                            @foreach ($grado as $g)
                                                <option value="{{ $g->grado }}">{{ $g->grado }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4 d-flex align-items-end mb-3">
                                    <button type="button" class="btn btn-primary btn-block btn-aplicar-filtro"
                                        data-tabla="tablaAsistentes">
                                        <i class="fas fa-search mr-1"></i> Aplicar Filtros
                                    </button>
                                </div>
                            </div>
                        </div>

                        <div class="table-responsive">
                            <table id="tablaAsistentes" class="display table table-striped table-asistentes" cellspacing="0"
                                width="100%">
                                <thead>
                                    <tr>
                                        <th class="text-center">
                                            <span class="select-header-text">Todos</span>
                                        </th>
                                        <th>DNI</th>
                                        <th>Nombre del padre</th>
                                        <th>Nivel</th>
                                        <th>Grado</th>
                                        <th>Estado</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($padresFamilia as $item)
                                        @if ($item->esta_vinculado_en_reunion == 'si' && $item->ha_pagado == 'si')
                                            <tr>
                                                <td class="text-center">
                                                    <input type="checkbox"
                                                        data-idparticipante="{{ $item->id_padre_familia }}"
                                                        class="form-check select-item select-asistente" checked disabled>
                                                </td>
                                                <td>{{ $item->padre_dni }}</td>
                                                <td>{{ $item->padre_ape_pat }} {{ $item->padre_ape_mat }}
                                                    {{ $item->padre_nombres }}</td>
                                                <td>{{ $item->nivel ?? 'No asignado' }}</td>
                                                <td>{{ $item->grado ?? 'No asignado' }}</td>
                                                <td><span class="badge badge-success">Asistió</span></td>
                                            </tr>
                                        @endif
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <!-- Pestaña: Padres asignados no asistentes -->
                    <div class="tab-pane fade" id="no-asistentes" role="tabpanel" aria-labelledby="no-asistentes-tab">
                        <div class="filtros-container mb-4">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group mb-3">
                                        <label for="filtroNivelNoAsistentes" class="mb-2">
                                            <i class="fas fa-filter mr-1"></i> Filtrar por nivel:
                                            <small class="text-muted">(Use Ctrl+clic para seleccionar varios)</small>
                                        </label>
                                        <select id="filtroNivelNoAsistentes" class="form-control filtro-nivel"
                                            multiple="multiple">
                                            @foreach ($nivel as $n)
                                                <option value="{{ $n->nivel }}">{{ $n->nivel }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group mb-3">
                                        <label for="filtroGradoNoAsistentes" class="mb-2">
                                            <i class="fas fa-filter mr-1"></i> Filtrar por grado:
                                            <small class="text-muted">(Use Ctrl+clic para seleccionar varios)</small>
                                        </label>
                                        <select id="filtroGradoNoAsistentes" class="form-control filtro-grado"
                                            multiple="multiple">
                                            @foreach ($grado as $g)
                                                <option value="{{ $g->grado }}">{{ $g->grado }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4 d-flex align-items-end mb-3">
                                    <div class="row w-100">
                                        <div class="col-md-12">
                                            <button type="button" class="btn btn-primary btn-block btn-aplicar-filtro"
                                                data-tabla="tablaNoAsistentes">
                                                <i class="fas fa-search mr-1"></i> Aplicar
                                            </button>
                                            <button type="button" id="btnEliminarSeleccionados"
                                                class="btn btn-danger btn-block">
                                                <i class="fas fa-trash-alt mr-1"></i> Eliminar
                                            </button>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="table-responsive">
                            <table id="tablaNoAsistentes" class="display table table-striped table-no-asistentes"
                                cellspacing="0" width="100%">
                                <thead>
                                    <tr>
                                        <th class="text-center">
                                            <span class="select-header-text" id="label-no-asistentes">Todos</span>
                                            <input type="checkbox" class="form-check select-all" id="todosNoAsistentes">
                                        </th>
                                        <th>DNI</th>
                                        <th>Nombre del padre</th>
                                        <th>Nivel</th>
                                        <th>Grado</th>
                                        <th>Estado</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($padresFamilia as $item)
                                        @if ($item->esta_vinculado_en_reunion == 'si' && $item->ha_pagado == 'no')
                                            <tr>
                                                <td class="text-center">
                                                    <input type="checkbox"
                                                        data-idparticipante="{{ $item->id_padre_familia }}"
                                                        class="form-check select-item select-no-asistente">
                                                </td>
                                                <td>{{ $item->padre_dni }}</td>
                                                <td>{{ $item->padre_ape_pat }} {{ $item->padre_ape_mat }}
                                                    {{ $item->padre_nombres }}</td>
                                                <td>{{ $item->nivel ?? 'No asignado' }}</td>
                                                <td>{{ $item->grado ?? 'No asignado' }}</td>
                                                <td><span class="badge badge-warning">No asistió</span></td>
                                            </tr>
                                        @endif
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <!-- Pestaña: Padres no asignados -->
                    <div class="tab-pane fade" id="no-asignados" role="tabpanel" aria-labelledby="no-asignados-tab">
                        <div class="filtros-container mb-4">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group mb-3">
                                        <label for="filtroNivelNoAsignados" class="mb-2">
                                            <i class="fas fa-filter mr-1"></i> Filtrar por nivel:
                                            <small class="text-muted">(Use Ctrl+clic para seleccionar varios)</small>
                                        </label>
                                        <select id="filtroNivelNoAsignados" class="form-control filtro-nivel"
                                            multiple="multiple">
                                            @foreach ($nivel as $n)
                                                <option value="{{ $n->nivel }}">{{ $n->nivel }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group mb-3">
                                        <label for="filtroGradoNoAsignados" class="mb-2">
                                            <i class="fas fa-filter mr-1"></i> Filtrar por grado:
                                            <small class="text-muted">(Use Ctrl+clic para seleccionar varios)</small>
                                        </label>
                                        <select id="filtroGradoNoAsignados" class="form-control filtro-grado"
                                            multiple="multiple">
                                            @foreach ($grado as $g)
                                                <option value="{{ $g->grado }}">{{ $g->grado }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4 d-flex align-items-end mb-3">
                                    <div class="row w-100">
                                        <div class="col-md-12">
                                            <button type="button" class="btn btn-primary btn-block btn-aplicar-filtro"
                                                data-tabla="tablaNoAsignados">
                                                <i class="fas fa-search mr-1"></i> Aplicar
                                            </button>
                                            <button type="button" id="btnGuardarSalir"
                                                class="btn btn-success btn-block">
                                                <i class="fas fa-plus-circle mr-1"></i> Agregar
                                            </button>
                                        </div>

                                    </div>
                                </div>

                            </div>
                        </div>

                        <div class="table-responsive">
                            <table id="tablaNoAsignados" class="display table table-striped table-no-asignados"
                                cellspacing="0" width="100%">
                                <thead>
                                    <tr>
                                        <th class="text-center">
                                            <span class="select-header-text" id="label-no-asignados">Todos</span>
                                            <input type="checkbox" class="form-check select-all" id="todosNoAsignados">
                                        </th>
                                        <th>DNI</th>
                                        <th>Nombre del padre</th>
                                        <th>Nivel</th>
                                        <th>Grado</th>
                                        <th>Estado</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($padresFamilia as $item)
                                        @if ($item->esta_vinculado_en_reunion == 'no')
                                            <tr>
                                                <td class="text-center">
                                                    <input type="checkbox"
                                                        data-idparticipante="{{ $item->id_padre_familia }}"
                                                        class="form-check select-item select-no-asignado">
                                                </td>
                                                <td>{{ $item->padre_dni }}</td>
                                                <td>{{ $item->padre_ape_pat }} {{ $item->padre_ape_mat }}
                                                    {{ $item->padre_nombres }}</td>
                                                <td>{{ $item->nivel ?? 'No asignado' }}</td>
                                                <td>{{ $item->grado ?? 'No asignado' }}</td>
                                                <td><span class="badge badge-secondary">No asignado</span></td>
                                            </tr>
                                        @endif
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>


    <script>
        function confimar_eliminar() {
            let res = confirm('¿Estás seguro de eliminar todos los registros?');
            if (res) {
                return confirm(
                    'Por tu seguridad, te preguntamos nuevamente. ¿Estás seguro de eliminar todos los registros?');
            }
            return res;
        }

        $(document).ready(function() {
            // Variables para almacenar IDs seleccionados en todas las páginas
            var selectedNoAsignados = [];
            var selectedNoAsistentes = [];
            var selectedAsistentes = []; // Padres que ya asistieron (siempre incluidos)

            // Inicializar padres que ya asistieron (disabled)
            $('.select-asistente:disabled').each(function() {
                var id = $(this).data('idparticipante');
                if (id && !selectedAsistentes.includes(id)) {
                    selectedAsistentes.push(id);
                }
            });

            // Inicializar padres no asistentes (marcados por defecto)
            $('.select-no-asistente').each(function() {
                var id = $(this).data('idparticipante');
                if ($(this).prop('checked') && id && !selectedNoAsistentes.includes(id)) {
                    selectedNoAsistentes.push(id);
                }
            });

            // Extensión para filtrar por nivel y grado en DataTables
            $.fn.dataTable.ext.search.push(function(settings, data, dataIndex) {
                var tableId = settings.nTable.id;
                var nivelesSeleccionados = [];
                var gradosSeleccionados = [];

                if (tableId === 'tablaAsistentes') {
                    nivelesSeleccionados = $('#filtroNivelAsistentes').val() || [];
                    gradosSeleccionados = $('#filtroGradoAsistentes').val() || [];
                } else if (tableId === 'tablaNoAsistentes') {
                    nivelesSeleccionados = $('#filtroNivelNoAsistentes').val() || [];
                    gradosSeleccionados = $('#filtroGradoNoAsistentes').val() || [];
                } else if (tableId === 'tablaNoAsignados') {
                    nivelesSeleccionados = $('#filtroNivelNoAsignados').val() || [];
                    gradosSeleccionados = $('#filtroGradoNoAsignados').val() || [];
                }

                var nivel = data[3]; // Columna "Nivel"
                var grado = data[4]; // Columna "Grado"

                if (nivelesSeleccionados.length === 0 && gradosSeleccionados.length === 0) {
                    return true;
                }

                var pasaNivel = nivelesSeleccionados.length > 0 ?
                    nivelesSeleccionados.some(function(n) {
                        return nivel.includes(n);
                    }) :
                    true;
                var pasaGrado = gradosSeleccionados.length > 0 ?
                    gradosSeleccionados.some(function(g) {
                        return grado.includes(g);
                    }) :
                    true;
                return pasaNivel && pasaGrado;
            });

            // Inicializar DataTables
            var tablaAsistentes = $('#tablaAsistentes').DataTable({
                language: {
                    url: '//cdn.datatables.net/plug-ins/1.10.25/i18n/Spanish.json'
                },
                responsive: true,
                order: [
                    [2, 'asc']
                ],
                columnDefs: [{
                    orderable: false,
                    targets: 0
                }],
                drawCallback: function() {
                    $('.select-asistente', this.api().table().node()).each(function() {
                        var id = $(this).data('idparticipante');
                        if (selectedAsistentes.includes(id)) {
                            $(this).prop('checked', true);
                        }
                    });
                }
            });

            var tablaNoAsistentes = $('#tablaNoAsistentes').DataTable({
                language: {
                    url: '//cdn.datatables.net/plug-ins/1.10.25/i18n/Spanish.json'
                },
                responsive: true,
                order: [
                    [2, 'asc']
                ],
                columnDefs: [{
                    orderable: false,
                    targets: 0
                }],
                drawCallback: function() {
                    $('.select-no-asistente', this.api().table().node()).each(function() {
                        var id = $(this).data('idparticipante');
                        $(this).prop('checked', selectedNoAsistentes.includes(id));
                    });
                    var allChecked = true;
                    $('.select-no-asistente:visible').each(function() {
                        if (!$(this).prop('checked')) {
                            allChecked = false;
                            return false;
                        }
                    });
                    $('#todosNoAsistentes').prop('checked', allChecked && $(
                        '.select-no-asistente:visible').length > 0);
                }
            });

            var tablaNoAsignados = $('#tablaNoAsignados').DataTable({
                language: {
                    url: '//cdn.datatables.net/plug-ins/1.10.25/i18n/Spanish.json'
                },
                responsive: true,
                order: [
                    [2, 'asc']
                ],
                columnDefs: [{
                    orderable: false,
                    targets: 0
                }],
                drawCallback: function() {
                    $('.select-no-asignado', this.api().table().node()).each(function() {
                        var id = $(this).data('idparticipante');
                        $(this).prop('checked', selectedNoAsignados.includes(id));
                    });
                    var allChecked = true;
                    $('.select-no-asignado:visible').each(function() {
                        if (!$(this).prop('checked')) {
                            allChecked = false;
                            return false;
                        }
                    });
                    $('#todosNoAsignados').prop('checked', allChecked && $(
                        '.select-no-asignado:visible').length > 0);
                }
            });

            // Activar checkbox al hacer clic sobre "Todos"
            $('#label-no-asistentes').on('click', function() {
                $('#todosNoAsistentes').trigger('click');
            });
            $('#label-no-asignados').on('click', function() {
                $('#todosNoAsignados').trigger('click');
            });

            function actualizarContadoresPestanas() {
                $('#contador-asistentes').text(tablaAsistentes.rows().count());
                $('#contador-no-asistentes').text(tablaNoAsistentes.rows().count());
                $('#contador-no-asignados').text(tablaNoAsignados.rows().count());
            }

            $('.btn-aplicar-filtro').on('click', function() {
                var tablaId = $(this).data('tabla');
                if (tablaId === 'tablaAsistentes') {
                    tablaAsistentes.draw();
                } else if (tablaId === 'tablaNoAsistentes') {
                    tablaNoAsistentes.draw();
                    // Después de filtrar, actualizar estado del checkbox "Todos"
                    actualizarCheckboxTodos("todosNoAsistentes", ".select-no-asistente");
                } else if (tablaId === 'tablaNoAsignados') {
                    tablaNoAsignados.draw();
                    // Después de filtrar, actualizar estado del checkbox "Todos"
                    actualizarCheckboxTodos("todosNoAsignados", ".select-no-asignado");
                }
            });
            
            // Función para actualizar el estado del checkbox "Todos" basado en los elementos visibles
            function actualizarCheckboxTodos(checkboxId, selectorItems) {
                var allChecked = true;
                var visibleCount = 0;
                
                $(selectorItems + ':visible').each(function() {
                    visibleCount++;
                    if (!$(this).prop('checked')) {
                        allChecked = false;
                        return false;
                    }
                });
                
                // Sólo marcar como "todos seleccionados" si hay elementos visibles y todos están marcados
                $('#' + checkboxId).prop('checked', allChecked && visibleCount > 0);
            }

            // "Seleccionar todos" en tabla No Asistentes
            $('#todosNoAsistentes').on('change', function() {
                var isChecked = $(this).prop('checked');
                
                // Primero actualizar UI para feedback inmediato
                $('.select-no-asistente:visible').prop('checked', isChecked);
                
                // Luego actualizar el array de selecciones según los registros visibles
                tablaNoAsistentes.rows({search: 'applied'}).every(function() {
                    var checkbox = $(this.node()).find('.select-no-asistente');
                    var id = checkbox.data('idparticipante');
                    
                    if (isChecked) {
                        // Agregar solo si no existe ya en el array
                        if (id && !selectedNoAsistentes.includes(id)) {
                            selectedNoAsistentes.push(id);
                        }
                    } else {
                        // Remover ID cuando se desmarca
                        selectedNoAsistentes = selectedNoAsistentes.filter(item => item !== id);
                    }
                    // Actualizar visualmente el checkbox según corresponda
                    checkbox.prop('checked', isChecked);
                });
                
                actualizarContador();
            });

            // "Seleccionar todos" en tabla No Asignados
            $('#todosNoAsignados').on('change', function() {
                var isChecked = $(this).prop('checked');
                
                // Primero actualizar UI para feedback inmediato
                $('.select-no-asignado:visible').prop('checked', isChecked);
                
                // Luego actualizar el array de selecciones según los registros visibles
                tablaNoAsignados.rows({search: 'applied'}).every(function() {
                    var checkbox = $(this.node()).find('.select-no-asignado');
                    var id = checkbox.data('idparticipante');
                    
                    if (isChecked) {
                        // Agregar solo si no existe ya en el array
                        if (id && !selectedNoAsignados.includes(id)) {
                            selectedNoAsignados.push(id);
                        }
                    } else {
                        // Remover ID cuando se desmarca
                        selectedNoAsignados = selectedNoAsignados.filter(item => item !== id);
                    }
                    // Actualizar visualmente el checkbox según corresponda
                    checkbox.prop('checked', isChecked);
                });
                
                actualizarContador();
                console.log("Padres no asignados seleccionados: " + selectedNoAsignados.length);
            });

            // Selecciones individuales en tabla No Asistentes
            $(document).on('change', '.select-no-asistente', function() {
                var id = $(this).data('idparticipante');
                if ($(this).prop('checked') && !selectedNoAsistentes.includes(id)) {
                    selectedNoAsistentes.push(id);
                } else if (!$(this).prop('checked')) {
                    selectedNoAsistentes = selectedNoAsistentes.filter(item => item !== id);
                }
                actualizarContador();
                var allChecked = true;
                $('.select-no-asistente:visible').each(function() {
                    if (!$(this).prop('checked')) {
                        allChecked = false;
                        return false;
                    }
                });
                $('#todosNoAsistentes').prop('checked', allChecked);
            });

            // Selecciones individuales en tabla No Asignados
            $(document).on('change', '.select-no-asignado', function() {
                var id = $(this).data('idparticipante');
                if ($(this).prop('checked') && !selectedNoAsignados.includes(id)) {
                    selectedNoAsignados.push(id);
                } else if (!$(this).prop('checked')) {
                    selectedNoAsignados = selectedNoAsignados.filter(item => item !== id);
                }
                actualizarContador();
                var allChecked = true;
                $('.select-no-asignado:visible').each(function() {
                    if (!$(this).prop('checked')) {
                        allChecked = false;
                        return false;
                    }
                });
                $('#todosNoAsignados').prop('checked', allChecked);
            });

            function actualizarContador() {
                var total = selectedNoAsistentes.length + selectedNoAsignados.length;
                $('#contadorSeleccionados').text(total);
            }

            $(document).on('click', '.agregar-padre', function() {
                var id = $(this).data('id');
                if (!selectedNoAsignados.includes(id)) {
                    selectedNoAsignados.push(id);
                }
                $(this).closest('tr').find('.select-no-asignado').prop('checked', true);
                actualizarContador();
            });

            $(document).on('click', '.quitar-padre', function() {
                var id = $(this).data('id');
                selectedNoAsistentes = selectedNoAsistentes.filter(item => item !== id);
                $(this).closest('tr').find('.select-no-asistente').prop('checked', false);
                actualizarContador();
            });

            actualizarContador();
            actualizarContadoresPestanas();
            setTimeout(function() {
                actualizarContadoresPestanas();
            }, 500);

            $('#btnEliminarSeleccionados').click(function() {
                if (selectedNoAsistentes.length === 0) {
                    new PNotify({
                        title: "ADVERTENCIA",
                        type: "warning",
                        text: "Debe seleccionar al menos un padre para eliminar",
                        styling: "bootstrap3"
                    });
                    return;
                }
                if (confirm('¿Está seguro de eliminar los ' + selectedNoAsistentes.length +
                        ' padres seleccionados?')) {
                    if (confirm('Esta acción no se puede deshacer. ¿Desea continuar?')) {
                        var idReunion = $('#id_reunion_actual').val();

                        // Crear un formulario dinámico para enviar por POST
                        var form = $('<form>', {
                            'method': 'POST',
                            'action': '{{ url('reuniones/eliminarParticipanteSeleccionados') }}/' +
                                idReunion
                        });

                        // Agregar token CSRF para Laravel
                        form.append($('<input>', {
                            'type': 'hidden',
                            'name': '_token',
                            'value': '{{ csrf_token() }}'
                        }));

                        // Agregar los IDs como campo oculto
                        form.append($('<input>', {
                            'type': 'hidden',
                            'name': 'padres_seleccionados',
                            'value': selectedNoAsistentes.join(',')
                        }));

                        // Añadir al documento, enviar y eliminar
                        $('body').append(form);
                        form.submit();
                    }
                }
            });

            $('#btnGuardarSalir').click(function(e) {
                e.preventDefault();
                if ($('#no-asignados-tab').hasClass('active') && selectedNoAsignados.length === 0) {
                    new PNotify({
                        title: "ADVERTENCIA",
                        type: "warning",
                        text: "Debe seleccionar al menos un padre de familia de la tabla NO ASIGNADOS",
                        styling: "bootstrap3"
                    });
                    return;
                }
                var selectedParticipants = [...selectedNoAsistentes, ...selectedNoAsignados, ...
                    selectedAsistentes
                ];
                selectedParticipants = [...new Set(selectedParticipants)];
                if (selectedParticipants.length === 0) {
                    new PNotify({
                        title: "ADVERTENCIA",
                        type: "warning",
                        text: "Debe seleccionar al menos un padre de familia",
                        styling: "bootstrap3"
                    });
                    return;
                }
                $('#txtidparticipante').val(selectedParticipants.join(','));
                console.log(selectedParticipants.length + ' participantes seleccionados');
                $('#form').submit();
            });

            $('a[data-toggle="tab"]').on('shown.bs.tab', function(e) {
                setTimeout(function() {
                    $($.fn.dataTable.tables(true)).DataTable().responsive.recalc();
                }, 10);
            });

            // Después de cada redibujado de las tablas, actualizar estado de checkboxes
            tablaNoAsistentes.on('draw', function() {
                // Actualizar estado de cada checkbox basado en su ID
                $('.select-no-asistente').each(function() {
                    var id = $(this).data('idparticipante');
                    $(this).prop('checked', selectedNoAsistentes.includes(id));
                });
                
                // Actualizar estado del checkbox "Todos"
                actualizarCheckboxTodos("todosNoAsistentes", ".select-no-asistente");
            });
            
            tablaNoAsignados.on('draw', function() {
                // Actualizar estado de cada checkbox basado en su ID
                $('.select-no-asignado').each(function() {
                    var id = $(this).data('idparticipante');
                    $(this).prop('checked', selectedNoAsignados.includes(id));
                });
                
                // Actualizar estado del checkbox "Todos"
                actualizarCheckboxTodos("todosNoAsignados", ".select-no-asignado");
            });
        });
    </script>
@endsection
