
<?php $__env->startSection('titulo', 'Pagos'); ?>
<?php $__env->startSection('content'); ?>

    <style>
        .rojo {
            background-color: #ffcccc !important;
            color: rgb(58, 12, 12) !important;
        }

        .verde {
            background-color: #ccffcc !important;
            color: rgb(7, 50, 26) !important;
        }

        .card-block {
            max-height: 400px;

        }

        .encabezado__tabla {
            background-color: rgb(47, 128, 182) !important;
            color: white;
        }

        .resultado {
            background: rgba(26, 150, 123, 0.88);
            color: white;
            margin-bottom: 20px;
        }

        /* Estilo para la tabla de pagos realizados */
        .encabezado__tabla_pagos {
            background-color: rgb(34, 91, 130) !important;
            color: white;
        }

        /* Estilo para las imágenes de boucher */
        .boucher-thumbnail {
            max-width: 100px;
            max-height: 100px;
            cursor: pointer;
        }

        .encabezado-pagos {
            background: rgb(30, 106, 157);
            color: white;
        }

        /* Estilo para la tabla de reuniones */
        .encabezado__tabla_reuniones {
            background-color: rgb(47, 128, 182) !important;
            color: white;
        }
    </style>
    


    <?php if(session('CORRECTO')): ?>
        <script>
            $(function notificacion() {
                new PNotify({
                    title: "CORRECTO",
                    type: "success",
                    text: "<?php echo e(session('CORRECTO')); ?>",
                    styling: "bootstrap3"
                });
            });
        </script>
    <?php endif; ?>

    <?php if(session('id_pago')): ?>
        <script>
            $(function notificacion() {
                new PNotify({
                    title: "CORRECTO",
                    type: "success",
                    text: "El pago se realizo con exito",
                    styling: "bootstrap3"
                });
            });


            $(function() {
                window.open("<?php echo e(route('pagos.ticketPago', ':id_pago')); ?>".replace(':id_pago',
                    '<?php echo e(session('id_pago')); ?>'), "_blank");
            });
        </script>
    <?php endif; ?>

    <?php if(session('id_pagos')): ?>
        <script>
            $(function notificacion() {
                new PNotify({
                    title: "CORRECTO",
                    type: "success",
                    text: "Los pagos se realizaron con éxito",
                    styling: "bootstrap3"
                });
            });

            // Abrir en una nueva pestaña la ruta ticketPagos y enviar los ids de los pagos como parámetro
            $(function() {
                const idPagos = <?php echo json_encode(session('id_pagos'), 15, 512) ?>;
                const comentarios = <?php echo json_encode(session('comentarios'), 15, 512) ?>;
                const url = "<?php echo e(route('pagos.ticketPagos')); ?>?id_pagos=" + encodeURIComponent(JSON.stringify(idPagos)) +
                    "&comentarios=" + encodeURIComponent(JSON.stringify(comentarios));
                window.open(url, "_blank");
            });
        </script>
    <?php endif; ?>

    <?php if(session('INCORRECTO')): ?>
        <script>
            $(function notificacion() {
                new PNotify({
                    title: "INCORRECTO",
                    type: "error",
                    text: "<?php echo e(session('INCORRECTO')); ?>",
                    styling: "bootstrap3"
                });
            });
        </script>
    <?php endif; ?>

    <h4 class="text-center text-secondary">REALIZA TUS PAGOS</h4>

    <div class="card-block" style="margin-bottom: -40px">
        <div class="resultado p-3">
            <?php $__currentLoopData = $nombrePadreFamilia; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php echo e($item->nombre); ?>

            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>

    <div class="card-block table-responsive table-one">

        <a href="<?php echo e(route('historial.descargaPDF', $dni_padre)); ?>" target="_blank" id="descarga"
            class="btn btn-primary"><i class="fas fa-file-pdf"></i> Imprimir historial</a>

        <!-- Botón de "PAGAR" que se mostrará solo cuando se seleccione al menos un checkbox -->
        <button id="pagarSeleccionados" class="btn btn-secondary" style="display: none" data-toggle="modal"
            data-target="#pagarModal">PAGAR APORTES</button>

        <table id="example2" class="display table table-striped" cellspacing="0" width="100%">
            <thead class="table-primary">
                <tr>
                    <th colspan="12" class="encabezado__tabla">APORTES</th>
                </tr>
                <tr>
                    <th><input type="checkbox" id="selectAll"></th>
                    <th>N°</th>
                    <th>Titulo</th>
                    <th>Monto a aportar</th>
                    <th>Monto aportado</th>
                    <th>Debe</th>
                    <th>Fecha plazo</th>
                    <th>Comentarios</th>
                    <th>Acciones</th>
                </tr>
            </thead>

            <tbody id="tbody">
                <?php $__currentLoopData = $historialAportes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="<?php echo e(($item->debe == null) | ($item->debe > 0) ? 'rojo' : 'verde'); ?>">
                        <td>
                            <?php if($item->debe == null || $item->debe > 0): ?>
                                <input type="checkbox" class="checkboxPago" data-id="<?php echo e($item->id_aporte); ?>"
                                    data-titulo="<?php echo e($item->titulo); ?>" data-monto="<?php echo e($item->debe); ?>"
                                    data-monto-aportado="<?php echo e($item->monto_aportado); ?>"
                                    data-id-padre="<?php echo e($item->id_padre_familia); ?>">
                            <?php else: ?>
                                <input type="checkbox" class="checkboxPago" disabled>
                            <?php endif; ?>
                        </td>
                        <td><?php echo e($key + 1); ?></td>
                        <td><?php echo e($item->titulo); ?></td>
                        
                        <td>S/. <?php echo e($item->monto); ?> <b>X <?php echo e($cantidadHijos); ?> Hijos = <?php echo e($item->monto_aporte); ?></b></td>
                        <td>S/. <?php echo e($item->monto_aportado); ?></td>
                        <td>S/. <?php echo e($item->debe); ?></td>
                        <td><?php echo e($item->fecha); ?></td>

                        <td><?php echo e($item->comentario); ?></td>
                        <td>
                            <?php if($item->debe == null || $item->debe > 0): ?>
                                <a href="" data-toggle="modal" data-target="#registrar<?php echo e($item->id_aporte); ?>"
                                    class="btn btn-sm bg-dark"><i class="fas fa-dollar-sign"></i> Pagar</a>
                                
                                <a href="" data-toggle="modal" data-target="#editar<?php echo e($item->id_aporte); ?>"
                                    class="btn btn-sm btn-warning"><i class="fas fa-edit"></i></a>
                            <?php endif; ?>
                        </td>
                    </tr>


                    <!-- Modal registrar pago de aportes -->
                    <div class="modal fade" id="registrar<?php echo e($item->id_aporte); ?>" tabindex="-1"
                        aria-labelledby="exampleModalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header d-flex justify-content-between">
                                    <h5 class="modal-title w-100" id="exampleModalLabel">Registrar Pago</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form action="<?php echo e(route('pagos.store')); ?>" method="POST"
                                        data-form-id="formAporte-<?php echo e($item->id_aporte); ?>" enctype="multipart/form-data">
                                        <?php echo csrf_field(); ?>

                                        <input type="hidden" name="txtidaporte" value="<?php echo e($item->id_aporte); ?>">
                                        <input type="hidden" name="txtidpadre" value="<?php echo e($item->id_padre_familia); ?>">
                                        <input type="hidden" name="txtidusuario" value="<?php echo e(Auth::user()->id_usuario); ?>">

                                        
                                        <div class="mb-4 px-2 col-12">
                                            <label>Fecha de pago/boucher</label>
                                            <input required type="date" placeholder="Fecha de pago" name="txtfechapago"
                                                class="input input__text" value="<?php echo e(old('txtfechapago', date('Y-m-d'))); ?>">
                                            <?php $__errorArgs = ['txtfechapago'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p class="error-message text-danger p-2">Este campo es obligatorio</p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        
                                        <div class="mb-4 px-2 col-12">
                                            <label>N° operacion/boucher</label>
                                            <input type="text" name="txtnumerorecibo" class="input input__text"
                                                value="<?php echo e(old('txtnumerorecibo')); ?>">
                                            <?php $__errorArgs = ['txtnumerorecibo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p class="error-message text-danger p-2">Este campo es obligatorio</p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <div class="mb-4 px-2 col-12">
                                            <label>Monto que queda por aportar</label>
                                            <input required readonly type="text" placeholder="Monto a aportar"
                                                name="txtmontoaportar" class="input input__text"
                                                data-form-id="txtmontoaportar-<?php echo e($item->id_aporte); ?>"
                                                value="<?php echo e(old('txtmontoaportar', $item->monto_aporte - $item->monto_aportado)); ?>">
                                            <?php $__errorArgs = ['txtmontoaportar'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p class="error-message text-danger p-2">Este campo es obligatorio</p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>


                                        <div class="mb-4 px-2 col-12">
                                            <label>Monto aportado</label>
                                            <input required type="number" step="0.5" placeholder=""
                                                class="input input__text" name="txtmontoaportado"
                                                data-form-id="txtmontoaportado-<?php echo e($item->id_aporte); ?>"
                                                class="monto-aportado" value="<?php echo e(old('txtmontoaportado')); ?>">
                                            <?php $__errorArgs = ['txtmontoaportado'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p class="error-message text-danger p-2">Este campo es obligatorio</p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <div class="mb-4 px-2 col-12">
                                            <label>Monto que debe</label>
                                            <input required readonly type="text" placeholder=""
                                                data-form-id="txtmontodebe-<?php echo e($item->id_aporte); ?>"
                                                class="input input__text" name="txtmontodebe"
                                                value="<?php echo e(old('txtmontodebe', $item->debe)); ?>">
                                            <?php $__errorArgs = ['txtmontodebe'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p class="error-message text-danger p-2">Este campo es obligatorio</p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>


                                        <div class="mb-4 px-2 col-12">
                                            <label>Foto/boucher</label>
                                            <input type="file" name="txtfotoboucher" class="input input__text"
                                                value="<?php echo e(old('txtfotoboucher')); ?>" accept=".png, .jpg, .jpeg, .pdf">
                                            <?php $__errorArgs = ['txtfotoboucher'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p class="error-message text-danger p-2"><?php echo e($message); ?></p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>


                                        <div class="mb-4 px-2 col-12">
                                            <label>Comentarios</label>
                                            <textarea name="txtcomentarios" rows="1" class="input input__text"
                                                data-form-id="txtcomentarios-<?php echo e($item->id_aporte); ?>"><?php echo e(old('txtcomentarios')); ?></textarea>
                                            <?php $__errorArgs = ['txtcomentarios'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p class="error-message text-danger p-2">Este campo es obligatorio</p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>


                                        <div class="text-right p-2">
                                            <a data-dismiss="modal" class="btn btn-secondary btn-rounded">Atras</a>
                                            <button type="submit" value="ok" name="btnmodificar"
                                                class="btn btn-primary btn-rounded">Registrar pago</button>
                                        </div>
                                    </form>
                                </div>

                            </div>
                        </div>
                    </div>

                    <!-- Modal editar pago de aportes -->
                    <div class="modal fade" id="editar<?php echo e($item->id_aporte); ?>" tabindex="-1"
                        aria-labelledby="exampleModalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header d-flex justify-content-between">
                                    <h5 class="modal-title w-100" id="exampleModalLabel">Modificar Pago</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form action="<?php echo e(route('pagos.editarPago')); ?>" method="POST"
                                        data-form-id="formAporte-<?php echo e($item->id_aporte); ?>">
                                        <?php echo csrf_field(); ?>

                                        <input type="hidden" name="txtidaporte" value="<?php echo e($item->id_aporte); ?>">
                                        <input type="hidden" name="txtidpadre" value="<?php echo e($item->id_padre_familia); ?>">
                                        <input type="hidden" name="txtidusuario"
                                            value="<?php echo e(Auth::user()->id_usuario); ?>">

                                        <div class="mb-4 px-2 col-12">
                                            <label>Monto que queda por aportar</label>
                                            <input required type="text" placeholder="Monto a aportar"
                                                name="txtmontoaportar" class="input input__text"
                                                data-form-id="txtmontoaportar-<?php echo e($item->id_aporte); ?>"
                                                value="<?php echo e(old('txtmontoaportar', $item->monto_aporte - $item->monto_aportado)); ?>">
                                            <?php $__errorArgs = ['txtmontoaportar'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p class="error-message text-danger p-2">Este campo es obligatorio</p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>


                                        
                                        <div class="mb-4 px-2 col-12">
                                            <label>Comentarios</label>
                                            <textarea name="txtcomentarios" required class="input input__text"
                                                data-form-id="txtcomentarios-<?php echo e($item->id_aporte); ?>"><?php echo e(old('txtcomentarios', $item->comentario)); ?></textarea>
                                            <?php $__errorArgs = ['txtcomentarios'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p class="error-message text-danger p-2">Este campo es obligatorio</p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>



                                        <div class="text-right p-2">
                                            <a data-dismiss="modal" class="btn btn-secondary btn-rounded">Atras</a>
                                            <button type="submit" value="ok" name="btnmodificar"
                                                class="btn btn-primary btn-rounded">Modificar</button>
                                        </div>
                                    </form>
                                </div>

                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </tbody>
        </table>
    </div>

    <!-- Modal para mostrar los aportes seleccionados -->
    <div class="modal fade" id="pagarModal" tabindex="-1" aria-labelledby="pagarModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header encabezado-pagos">
                    <h5 class="modal-title w-100" id="pagarModalLabel">
                        <i class="fas fa-money-bill-wave mr-2"></i> Registrar Pagos Múltiples
                    </h5>
                    <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="formPago" method="POST" action="<?php echo e(route('pagos.registrarPagos')); ?>"
                        enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div id="aportesSeleccionados"></div>

                        <div class="row mb-3">
                            <!-- Datos comunes para todos los pagos -->
                            <div class="col-md-6 mb-3">
                                <label class="font-weight-bold">Fecha de pago/boucher:</label>
                                <input required type="date" name="fecha_pago" class="form-control"
                                    value="<?php echo e(date('Y-m-d')); ?>">
                            </div>

                            <div class="col-md-6 mb-3">
                                <label class="font-weight-bold">N° operación/boucher:</label>
                                <input type="text" name="numero_recibo" class="form-control"
                                    placeholder="Ingrese el número de operación">
                            </div>

                            <div class="col-md-12 mb-4">
                                <label class="font-weight-bold">Imagen de comprobante/boucher:</label>
                                <input type="file" name="foto_boucher" class="form-control-file"
                                    accept=".png, .jpg, .jpeg, .pdf">
                                <small class="text-muted">Formatos permitidos: jpg, jpeg, png, pdf</small>
                            </div>
                        </div>

                        <div class="card mb-4">
                            <div class="card-header bg-light">
                                <h6 class="mb-0"><i class="fas fa-list-alt mr-2"></i> Detalle de Aportes Seleccionados
                                </h6>
                            </div>
                            <div class="card-body" id="modalBody">
                                <!-- Los detalles de los aportes seleccionados se agregarán aquí -->
                            </div>
                            <div class="card-footer bg-light">
                                <div class="text-right">
                                    <h5 id="totalPagar" class="font-weight-bold text-primary mb-0">Total a pagar: S/. 0.00
                                    </h5>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="font-weight-bold">Comentarios adicionales:</label>
                            <textarea class="form-control" name="comentarios" rows="2"
                                placeholder="Ingrese comentarios sobre este pago (opcional)"></textarea>
                        </div>

                        <div class="text-center mt-4">
                            <button type="button" class="btn btn-secondary mr-2" data-dismiss="modal">
                                <i class="fas fa-times mr-1"></i> Cancelar
                            </button>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-check mr-1"></i> Confirmar Pagos
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="card-block table-responsive">
        <!-- Botón de "PAGAR MULTAS" que se mostrará solo cuando se seleccione al menos un checkbox de reunión -->
        <button id="pagarReunionesSeleccionadas" class="btn btn-secondary" style="display: none"
            data-toggle="modal" data-target="#pagarReunionesModal">PAGAR MULTAS</button>

        <table id="example3" class="display table table-striped" cellspacing="0" width="100%">
            <thead class="table-primary">
                <tr>
                    <th colspan="9" class="encabezado__tabla">REUNIONES</th>
                </tr>
                <tr>
                    <th><input type="checkbox" id="selectAllReuniones"></th>
                    <th>N°</th>
                    <th>Titulo</th>
                    
                    <th>Multa</th>
                    <th>Fecha reunion</th>
                    <th>Asistencia</th>
                    <th>Estado de la reunion</th>
                    <th>Acciones</th>
                </tr>
            </thead>

            <tbody id="tbodyreuniones">
                <?php $__currentLoopData = $historialReuniones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr
                        class="<?php echo e($item->asistencia == null && ($item->detalles == '' || $item->detalles == null) ? 'rojo' : 'verde'); ?>">
                        <td>
                            <?php if($item->asistencia == null && ($item->detalles == '' || $item->detalles == null)): ?>
                                <input type="checkbox" class="checkboxReunion" data-id="<?php echo e($item->id_reunion); ?>"
                                    data-titulo="<?php echo e($item->titulo); ?>" data-multa="<?php echo e($item->multa_precio); ?>"
                                    data-id-padre="<?php echo e($item->id_padre_familia); ?>">
                            <?php else: ?>
                                <input type="checkbox" class="checkboxReunion" disabled>
                            <?php endif; ?>
                        </td>
                        <td><?php echo e($key + 1); ?></td>
                        <td><?php echo e($item->titulo); ?></td>
                        
                        <td>S/. <?php echo e($item->multa_precio); ?></td>
                        <td><?php echo e($item->fecha); ?> - <?php echo e($item->hora); ?></td>
                        <td>
                            <?php if($item->asistencia == null and ($item->detalles == '' or $item->detalles == null)): ?>
                                <span class="btn btn-sm btn-danger">Falta</span>
                            <?php else: ?>
                                <?php if($item->asistencia != null or $item->asistencia != ''): ?>
                                    <span class="btn btn-sm btn-success"><?php echo e($item->asistencia); ?></span>
                                <?php else: ?>
                                    <span class="btn btn-sm btn-success"><?php echo e($item->detalles); ?></span>
                                <?php endif; ?>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if($item->estado == 'ACTIVO'): ?>
                                <span class="btn btn-sm btn-success"><?php echo e($item->estado); ?></span>
                            <?php else: ?>
                                <span class="btn btn-sm btn-danger"><?php echo e($item->estado); ?></span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if($item->asistencia == null and ($item->detalles == '' or $item->detalles == null)): ?>
                                <a href="" data-toggle="modal" data-target="#multa<?php echo e($item->id_reunion); ?>"
                                    class="btn btn-sm bg-dark"><i class="fas fa-dollar-sign"></i> Pagar</a>
                            <?php else: ?>
                                <a href="" class="btn btn-sm bg-dark disabled"><i class="fas fa-dollar-sign"></i>
                                    Pagar</a>
                            <?php endif; ?>
                        </td>
                    </tr>

                    <!-- Modal registrar multa de reunion-->
                    <div class="modal fade" id="multa<?php echo e($item->id_reunion); ?>" tabindex="-1"
                        aria-labelledby="exampleModalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header d-flex justify-content-between">
                                    <h5 class="modal-title w-100" id="exampleModalLabel">Registrar Pago de Multa</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form action="<?php echo e(route('pagos.pagarMultaReunion')); ?>" method="POST"
                                        enctype="multipart/form-data" data-form-id="formMulta-<?php echo e($item->id_reunion); ?>">
                                        <?php echo csrf_field(); ?>

                                        <input type="hidden" name="txtidreunion" value="<?php echo e($item->id_reunion); ?>">
                                        <input type="hidden" name="txtidpadre" value="<?php echo e($item->id_padre_familia); ?>">
                                        <input type="hidden" name="txtidusuario"
                                            value="<?php echo e(Auth::user()->id_usuario); ?>">

                                        
                                        <div class="mb-4 px-2 col-12">
                                            <label>Fecha de pago/boucher</label>
                                            <input required type="date" placeholder="Fecha de pago"
                                                name="txtfechapago" class="input input__text"
                                                value="<?php echo e(old('txtfechapago', date('Y-m-d'))); ?>">
                                            <?php $__errorArgs = ['txtfechapago'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p class="error-message text-danger p-2">Este campo es obligatorio</p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        
                                        <div class="mb-4 px-2 col-12">
                                            <label>N° operacion/boucher</label>
                                            <input type="text" name="txtnumerorecibo" class="input input__text"
                                                value="<?php echo e(old('txtnumerorecibo')); ?>">
                                            <?php $__errorArgs = ['txtnumerorecibo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p class="error-message text-danger p-2">Este campo es obligatorio</p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <div class="mb-4 px-2 col-12">
                                            <label>Multa de la reunión</label>
                                            <input required readonly type="text" placeholder="Multa de la reunión"
                                                name="txtmulta" class="input input__text"
                                                data-form-id="txtmulta-<?php echo e($item->id_reunion); ?>"
                                                value="<?php echo e(old('txtmulta', $item->multa_precio)); ?>">
                                            <?php $__errorArgs = ['txtmulta'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p class="error-message text-danger p-2">Este campo es obligatorio</p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <div class="mb-4 px-2 col-12">
                                            <label>Monto pago</label>
                                            <input required readonly type="number" step="0.5" placeholder=""
                                                class="input input__text" name="txtpago"
                                                data-form-id="txtpago-<?php echo e($item->id_reunion); ?>" class="monto-aportado"
                                                value="<?php echo e(old('txtpago', $item->multa_precio)); ?>">
                                            <?php $__errorArgs = ['txtpago'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p class="error-message text-danger p-2">Este campo es obligatorio</p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <div class="mb-4 px-2 col-12">
                                            <label>Foto/boucher</label>
                                            <input type="file" name="txtfotoboucher" class="input input__text"
                                                value="<?php echo e(old('txtfotoboucher')); ?>" accept=".png, .jpg, .jpeg, .pdf">
                                            <?php $__errorArgs = ['txtfotoboucher'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p class="error-message text-danger p-2"><?php echo e($message); ?></p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <div class="mb-4 px-2 col-12">
                                            <label>Comentarios</label>
                                            <textarea name="txtcomentarios" rows="1" class="input input__text"
                                                data-form-id="txtcomentarios-<?php echo e($item->id_reunion); ?>"><?php echo e(old('txtcomentarios')); ?></textarea>
                                            <?php $__errorArgs = ['txtcomentarios'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p class="error-message text-danger p-2">Este campo es obligatorio</p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <div class="text-right p-2">
                                            <a data-dismiss="modal" class="btn btn-secondary btn-rounded">Atras</a>
                                            <button type="submit" value="ok" name="btnmodificar"
                                                class="btn btn-primary btn-rounded">Registrar pago</button>
                                        </div>
                                    </form>
                                </div>

                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </tbody>
        </table>
    </div>

    <!-- Modal para mostrar las reuniones seleccionadas y pagar multas -->
    <div class="modal fade" id="pagarReunionesModal" tabindex="-1" aria-labelledby="pagarReunionesModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header encabezado-pagos">
                    <h5 class="modal-title w-100" id="pagarReunionesModalLabel">
                        <i class="fas fa-money-bill-wave mr-2"></i> Registrar Pagos Múltiples de Multas
                    </h5>
                    <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="formPagoMultipleReuniones" method="POST"
                        action="<?php echo e(route('pagos.registrarPagosMultas')); ?>" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div id="reunionesSeleccionadas"></div>

                        <div class="row mb-3">
                            <!-- Datos comunes para todos los pagos -->
                            <div class="col-md-6 mb-3">
                                <label class="font-weight-bold">Fecha de pago/boucher:</label>
                                <input required type="date" name="fecha_pago" class="form-control"
                                    value="<?php echo e(date('Y-m-d')); ?>">
                            </div>

                            <div class="col-md-6 mb-3">
                                <label class="font-weight-bold">N° operación/boucher:</label>
                                <input type="text" name="numero_recibo" class="form-control"
                                    placeholder="Ingrese el número de operación">
                            </div>

                            <div class="col-md-12 mb-4">
                                <label class="font-weight-bold">Imagen de comprobante/boucher:</label>
                                <input type="file" name="foto_boucher" class="form-control-file"
                                    accept=".png, .jpg, .jpeg, .pdf">
                                <small class="text-muted">Formatos permitidos: jpg, jpeg, png, pdf</small>
                            </div>
                        </div>

                        <div class="card mb-4">
                            <div class="card-header bg-light">
                                <h6 class="mb-0"><i class="fas fa-list-alt mr-2"></i> Detalle de Multas Seleccionadas
                                </h6>
                            </div>
                            <div class="card-body" id="modalBodyReuniones">
                                <!-- Los detalles de las reuniones seleccionadas se agregarán aquí -->
                            </div>
                            <div class="card-footer bg-light">
                                <div class="text-right">
                                    <h5 id="totalPagarReuniones" class="font-weight-bold text-primary mb-0">Total a pagar:
                                        S/. 0.00</h5>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="font-weight-bold">Comentarios adicionales:</label>
                            <textarea class="form-control" name="comentarios" rows="2"
                                placeholder="Ingrese comentarios sobre este pago (opcional)"></textarea>
                        </div>

                        <div class="text-center mt-4">
                            <button type="button" class="btn btn-secondary mr-2" data-dismiss="modal">
                                <i class="fas fa-times mr-1"></i> Cancelar
                            </button>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-check mr-1"></i> Confirmar Pagos
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Tabla de pagos realizados -->
    <div class="card-block table-responsive">
        <table id="example4" class="display table table-striped" cellspacing="0" width="100%">
            <thead class="table-primary">
                <tr>
                    <th colspan="9" class="encabezado__tabla_pagos">PAGOS REALIZADOS</th>
                </tr>
                <tr>
                    <th>N°</th>
                    <th>Concepto</th>
                    <th>Monto pagado</th>
                    <th>Fecha de pago</th>
                    <th>Registrado por</th>
                    <th>Estado</th>
                    <th>Boucher</th>
                    <th>Comentarios</th>
                    <th>Opciones</th>
                </tr>
            </thead>

            <tbody>
                <?php $__currentLoopData = $historialPagos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $pago): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($key + 1); ?></td>
                        <td><?php echo e($pago->pago_concepto); ?></td>
                        <td>S/. <?php echo e($pago->monto_pago); ?></td>
                        <td><?php echo e($pago->fecha); ?></td>
                        <td><?php echo e($pago->nombres_usuario); ?></td>
                        <td>
                            <?php if(isset($pago->estado)): ?>
                                <?php if($pago->estado == 'ANULADO'): ?>
                                    <span class="badge bg-danger"><?php echo e($pago->estado); ?></span>
                                <?php elseif($pago->estado == 'EDITADO'): ?>
                                    <span class="badge bg-warning"><?php echo e($pago->estado); ?></span>
                                <?php else: ?>
                                    <span class="badge bg-success">VIGENTE</span>
                                <?php endif; ?>
                            <?php else: ?>
                                <span class="badge bg-success">VIGENTE</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if($pago->foto_boucher): ?>
                                <?php
                                    $extension = pathinfo($pago->foto_boucher, PATHINFO_EXTENSION);
                                ?>

                                <?php if(in_array(strtolower($extension), ['jpg', 'jpeg', 'png', 'gif'])): ?>
                                    <img src="<?php echo e(asset('storage/ARCHIVOS/pagos/' . $pago->foto_boucher)); ?>"
                                        class="boucher-thumbnail"
                                        onclick="window.open('<?php echo e(asset('storage/ARCHIVOS/pagos/' . $pago->foto_boucher)); ?>', '_blank')"
                                        alt="Boucher">
                                <?php else: ?>
                                    <a href="<?php echo e(asset('storage/ARCHIVOS/pagos/' . $pago->foto_boucher)); ?>"
                                        target="_blank">
                                        <i class="fas fa-file-pdf fa-2x text-danger"></i>
                                    </a>
                                <?php endif; ?>
                            <?php else: ?>
                                <span class="text-muted">Sin boucher</span>
                            <?php endif; ?>
                        </td>
                        <td><?php echo e($pago->comentario); ?></td>
                        <td>

                            <?php if((!isset($pago->estado) || $pago->estado != 'ANULADO') && $pago->monto_pago > 0): ?>
                                <a href="<?php echo e(route('pagos.ticketPago', $pago->id_pago)); ?>" target="_blank"
                                    class="btn btn-sm btn-info">
                                    <i class="fas fa-print"></i> Ticket
                                </a>
                                <a href="<?php echo e(route('pagos.edit', $pago->id_pago)); ?>" class="btn btn-sm btn-warning">
                                    <i class="fas fa-edit"></i> Editar
                                </a>
                                <a href="<?php echo e(route('pagos.anular', $pago->id_pago)); ?>" class="btn btn-sm btn-danger"
                                    onclick="return confirm('¿Está seguro que desea anular este pago?')">
                                    <i class="fas fa-ban"></i> Anular
                                </a>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>

    <!-- Tabla de historial de modificaciones -->
    <div class="card-block table-responsive mt-4">
        <table id="historial-modificaciones" class="display table table-striped" cellspacing="0" width="100%">
            <thead class="table-primary">
                <tr>
                    <th colspan="3" class="encabezado__tabla_pagos">HISTORIAL DE MODIFICACIONES DE PAGOS</th>
                    <th class="encabezado__tabla_pagos text-right">
                        <?php if(isset($historialModificaciones) && count($historialModificaciones) > 0): ?>
                            <a href="<?php echo e(route('pagos.limpiarHistorial', $id_padre_familia)); ?>" class="btn btn-sm btn-danger"
                                onclick="return confirm('¿Está seguro que desea eliminar todo el historial? Esta acción no se puede deshacer.')">
                                <i class="fas fa-trash"></i> Eliminar todo el historial
                            </a>
                        <?php endif; ?>
                    </th>
                </tr>
                <tr>
                    <th>N°</th>
                    <th>Descripción</th>
                    <th>Realizado por</th>
                    <th>Fecha</th>
                </tr>
            </thead>

            <tbody>
                <?php if(isset($historialModificaciones) && count($historialModificaciones) > 0): ?>
                    <?php $__currentLoopData = $historialModificaciones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $modificacion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($key + 1); ?></td>
                            <td><?php echo e($modificacion->descripcion); ?></td>
                            <td><?php echo e($modificacion->registrado_por); ?></td>
                            <td><?php echo e(date('d/m/Y H:i', strtotime($modificacion->fecha))); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <tr>
                        <td colspan="4" class="text-center">No hay historial de modificaciones</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>


    <script>
        let formAporte = document.querySelectorAll('[data-form-id^="formAporte-"]');
        let montoAportado = document.querySelectorAll('[data-form-id^="txtmontoaportado-"]');
        let montoDebe = document.querySelectorAll('[data-form-id^="txtmontodebe-"]');
        montoAportado.forEach((elemento) => {
            elemento.addEventListener('keyup', () => {
                let id = elemento.getAttribute('data-form-id');
                let idAporte = id.split('-')[1];
                let montoAportar = document.querySelector(`[data-form-id="txtmontoaportar-${idAporte}"]`)
                    .value;
                let montoAportado = parseFloat(elemento.value);
                let montoDebe = document.querySelector(`[data-form-id="txtmontodebe-${idAporte}"]`).value;
                //validar que el monto aportado no sea mayor al monto a aportar caso contrario poner el valor del monto a aportar
                if (montoAportado > montoAportar) {
                    elemento.value = montoAportar;
                    montoAportado = montoAportar;
                }
                //validar que el monto aportado no sea menor a 0 caso contrario poner el valor 0
                if (montoAportado < 0) {
                    elemento.value = 0;
                    montoAportado = 0;
                }
                //validar si esta vacio el monto aportado poner el valor 0
                if (montoAportado == '') {
                    elemento.value = 0;
                    montoAportado = 0;
                }
                let montoTotal = montoAportar - montoAportado;
                document.querySelector(`[data-form-id="txtmontodebe-${idAporte}"]`).value = montoTotal;
            })
        })
    </script>

    <script>
        let formMulta = document.querySelectorAll('[data-form-id^="formMulta-"]');
        let montoPago = document.querySelectorAll('[data-form-id^="txtpago-"]');
        let montoMulta = document.querySelectorAll('[data-form-id^="txtmulta-"]');

        montoPago.forEach((elemento) => {
            elemento.addEventListener('keyup', () => {
                let id = elemento.getAttribute('data-form-id');
                let idAporte = id.split('-')[1];
                let montoAportar = document.querySelector(`[data-form-id="txtmulta-${idAporte}"]`)
                    .value;
                let montoPago = parseFloat(elemento.value);
                let montoMulta = document.querySelector(`[data-form-id="txtmulta-${idAporte}"]`).value;
                //validar que el monto aportado no sea mayor al monto a aportar caso contrario poner el valor del monto a aportar
                if (montoPago > montoAportar) {
                    elemento.value = montoAportar;
                    montoPago = montoAportar;
                }
                //validar que el monto aportado no sea menor a 0 caso contrario poner el valor 0
                if (montoPago < 0) {
                    elemento.value = 0;
                    montoPago = 0;
                }
                //validar si esta vacio el monto aportado poner el valor 0
                if (montoPago == '') {
                    elemento.value = 0;
                    montoPago = 0;
                }
                // validar que el monto sea igual a la multa
                if (montoPago != montoMulta) {
                    elemento.value = montoMulta;
                    montoPago = montoMulta;
                }
            })
        })
    </script>

    <script>
        // Función para mostrar/ocultar sección de edición de imagen
        function toggleEditImage(idAporte) {
            const editSection = document.getElementById(`editImageSection-${idAporte}`);
            const saveButton = document.getElementById(`btnGuardarCambios-${idAporte}`);
            if (editSection.style.display === 'none') {
                editSection.style.display = 'block';
                saveButton.style.display = 'block';
            } else {
                editSection.style.display = 'none';
                saveButton.style.display = 'none';
            }
        }
    </script>

    <script>
        $(document).ready(function() {
            // Manejar el checkbox "Seleccionar todo"
            $('#selectAll').on('change', function() {
                $('.checkboxPago:not(:disabled)').prop('checked', $(this).prop('checked'));
                actualizarBotonPagar();
                actualizarModalPagos();
            });

            // Manejar los checkboxes individuales
            $('.checkboxPago').on('change', function() {
                actualizarBotonPagar();
                actualizarModalPagos();

                // Si desmarcamos algún checkbox, desmarcar también "Seleccionar todo"
                if (!$(this).prop('checked')) {
                    $('#selectAll').prop('checked', false);
                }

                // Si todos los checkboxes disponibles están marcados, marcar "Seleccionar todo"
                if ($('.checkboxPago:not(:disabled):checked').length === $('.checkboxPago:not(:disabled)')
                    .length) {
                    $('#selectAll').prop('checked', true);
                }
            });

            // Función para actualizar la visibilidad del botón "PAGAR"
            function actualizarBotonPagar() {
                const haySeleccionados = $('.checkboxPago:checked').length > 0;
                $('#pagarSeleccionados').toggle(haySeleccionados);
            }

            // Función para actualizar el contenido del modal con los aportes seleccionados
            function actualizarModalPagos() {
                const aportesSeleccionados = [];
                let totalAPagar = 0;
                let htmlDetalles = '';
                let inputsHtml = '';
                let idPadre = null;

                $('.checkboxPago:checked').each(function() {
                    const checkbox = $(this);
                    const id = checkbox.data('id');
                    const titulo = checkbox.data('titulo');
                    const monto = parseFloat(checkbox.data('monto'));
                    const montoAportado = parseFloat(checkbox.data('monto-aportado') || 0);
                    idPadre = checkbox.data('id-padre');

                    aportesSeleccionados.push({
                        id_aporte: id,
                        titulo: titulo,
                        monto: monto,
                        montoAportado: montoAportado
                    });

                    totalAPagar += monto;

                    // Crear una fila en la tabla para cada aporte seleccionado
                    htmlDetalles += `
                        <div class="card mb-3 border-left-primary">
                            <div class="card-body py-3">
                                <div class="row">
                                    <div class="col-md-7">
                                        <h6 class="font-weight-bold text-primary mb-1">${titulo}</h6>
                                        <div class="small text-muted mb-2">
                                            Monto pendiente: S/. ${monto.toFixed(2)}
                                        </div>
                                        <div class="small">
                                            Monto aportado previamente: S/. ${montoAportado.toFixed(2)}
                                        </div>
                                    </div>
                                    <div class="col-md-5">
                                        <label class="font-weight-bold">Monto a pagar:</label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text">S/.</span>
                                            </div>
                                            <input type="number" class="form-control monto-individual" 
                                                name="aportes[${id}][monto]" value="${monto.toFixed(2)}" 
                                                min="0" max="${monto}" step="0.01" required
                                                data-original="${monto}">
                                            <input type="hidden" name="aportes[${id}][id_aporte]" value="${id}">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    `;
                });

                if (idPadre) {
                    inputsHtml = `<input type="hidden" name="id_padre_familia" value="${idPadre}">`;
                }

                $('#modalBody').html(htmlDetalles ||
                    '<p class="text-center text-muted">No se han seleccionado aportes</p>');
                $('#aportesSeleccionados').html(inputsHtml);
                $('#totalPagar').text(`Total a pagar: S/. ${totalAPagar.toFixed(2)}`);

                // Agregar evento para recalcular el total cuando cambian los montos individuales
                $('.monto-individual').on('input', function() {
                    let nuevoTotal = 0;
                    $('.monto-individual').each(function() {
                        nuevoTotal += parseFloat($(this).val() || 0);
                    });
                    $('#totalPagar').text(`Total a pagar: S/. ${nuevoTotal.toFixed(2)}`);

                    // Validar que el monto no exceda el valor original
                    const max = parseFloat($(this).attr('data-original'));
                    const valor = parseFloat($(this).val() || 0);
                    if (valor > max) {
                        $(this).val(max.toFixed(2));
                    }
                    if (valor < 0) {
                        $(this).val(0);
                    }
                });
            }

            // Código para reuniones
            // Manejar el checkbox "Seleccionar todo" para reuniones
            $('#selectAllReuniones').on('change', function() {
                $('.checkboxReunion:not(:disabled)').prop('checked', $(this).prop('checked'));
                actualizarBotonPagarReuniones();
                actualizarModalPagosReuniones();
            });

            // Manejar los checkboxes individuales para reuniones
            $('.checkboxReunion').on('change', function() {
                actualizarBotonPagarReuniones();
                actualizarModalPagosReuniones();

                // Si desmarcamos algún checkbox, desmarcar también "Seleccionar todo"
                if (!$(this).prop('checked')) {
                    $('#selectAllReuniones').prop('checked', false);
                }

                // Si todos los checkboxes disponibles están marcados, marcar "Seleccionar todo"
                if ($('.checkboxReunion:not(:disabled):checked').length === $(
                        '.checkboxReunion:not(:disabled)').length) {
                    $('#selectAllReuniones').prop('checked', true);
                }
            });

            // Función para actualizar la visibilidad del botón "PAGAR MULTAS"
            function actualizarBotonPagarReuniones() {
                const haySeleccionados = $('.checkboxReunion:checked').length > 0;
                $('#pagarReunionesSeleccionadas').toggle(haySeleccionados);
            }

            // Función para actualizar el contenido del modal con las reuniones seleccionadas
            function actualizarModalPagosReuniones() {
                const reunionesSeleccionadas = [];
                let totalAPagar = 0;
                let htmlDetalles = '';
                let inputsHtml = '';
                let idPadre = null;

                $('.checkboxReunion:checked').each(function() {
                    const checkbox = $(this);
                    const id = checkbox.data('id');
                    const titulo = checkbox.data('titulo');
                    const multa = parseFloat(checkbox.data('multa'));
                    idPadre = checkbox.data('id-padre');

                    reunionesSeleccionadas.push({
                        id_reunion: id,
                        titulo: titulo,
                        multa: multa
                    });

                    totalAPagar += multa;

                    // Crear una fila en la tabla para cada reunión seleccionada
                    htmlDetalles += `
                        <div class="card mb-3 border-left-danger">
                            <div class="card-body py-3">
                                <div class="row">
                                    <div class="col-md-7">
                                        <h6 class="font-weight-bold text-danger mb-1">${titulo}</h6>
                                        <div class="small text-muted mb-2">
                                            Multa: S/. ${multa.toFixed(2)}
                                        </div>
                                    </div>
                                    <div class="col-md-5">
                                        <label class="font-weight-bold">Monto a pagar:</label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text">S/.</span>
                                            </div>
                                            <input type="number" class="form-control multa-individual" 
                                                name="multas[${id}][monto]" value="${multa.toFixed(2)}" 
                                                min="0" max="${multa}" step="0.01" required
                                                data-original="${multa}" readonly>
                                            <input type="hidden" name="multas[${id}][id_reunion]" value="${id}">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    `;
                });

                if (idPadre) {
                    inputsHtml = `<input type="hidden" name="id_padre_familia" value="${idPadre}">
                                  <input type="hidden" name="tipo_pago" value="reunion">`;
                }

                $('#modalBodyReuniones').html(htmlDetalles ||
                    '<p class="text-center text-muted">No se han seleccionado reuniones</p>');
                $('#reunionesSeleccionadas').html(inputsHtml);
                $('#totalPagarReuniones').text(`Total a pagar: S/. ${totalAPagar.toFixed(2)}`);

                // Agregar evento para recalcular el total cuando cambian los montos individuales
                $('.multa-individual').on('input', function() {
                    let nuevoTotal = 0;
                    $('.multa-individual').each(function() {
                        nuevoTotal += parseFloat($(this).val() || 0);
                    });
                    $('#totalPagarReuniones').text(`Total a pagar: S/. ${nuevoTotal.toFixed(2)}`);
                });
            }
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\SISTEMAS-INFORMACION\sis_apafa\resources\views/vistas/pagos/index.blade.php ENDPATH**/ ?>