<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <link rel="stylesheet" href="<?php echo e(asset('bootstrap4/css/bootstrap.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('inicio/css/style.css')); ?>">
    <link href="https://fonts.googleapis.com/css?family=Poppins:600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('fontawesome/css/all.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('fontawesome/css/fontawesome.min.css')); ?>">
    <link href="https://tresplazas.com/web/img/big_punto_de_venta.png" rel="shortcut icon">
    <title>Inicio de sesión</title>
    <style>
        #mi-formulario {
            display: none;
        }

        .title {
            font-size: 35px !important;
        }
    </style>
</head>

<body>
    <img class="wave" src="<?php echo e(asset('inicio/img/wave.png')); ?>">
    <div class="container">
        <div class="img">
            <img src="<?php echo e(asset('inicio/img/bg.svg')); ?>">
        </div>
        <div class="login-content">
            <form method="POST" action="<?php echo e(route('recuperar.enviarCorreo')); ?>">
                <?php echo csrf_field(); ?>
                <img src="<?php echo e(asset('inicio/img/avatar.svg')); ?>">
                <h2 class="title">RECUPERAR CLAVE</h2>

                <?php if(session('CORRECTO')): ?>
                    <div class="alert alert-success alert-dismissible fade show mb-0" role="alert">
                        <small><?php echo e(session('CORRECTO')); ?></small>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                    </div>
                <?php endif; ?>

                <?php if(session('INCORRECTO')): ?>
                    <div class="alert alert-danger alert-dismissible fade show mb-0" role="alert">
                        <small><?php echo e(session('INCORRECTO')); ?></small>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                    </div>
                <?php endif; ?>

                <?php $__errorArgs = ['usuario'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="alert alert-danger alert-dismissible fade show mb-2" role="alert">
                        <small><?php echo e($message); ?></small>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                <div class="input-div one">
                    <div class="i">
                        <i class="fas fa-user"></i>
                    </div>
                    <div class="div">
                        <h5>Ingrese su usuario</h5>
                        <input id="usuario" type="text"
                            class="input <?php $__errorArgs = ['usuario'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="usuario"
                            title="Ingrese su usuario" value="<?php echo e(old('usuario')); ?>">
                    </div>
                </div>

                <div class="text-center">
                    <a class="font-italic isai5" href="<?php echo e(route('login')); ?>" id="mostrar-formulario">Iniciar sesión</a>
                </div>

                <input name="btningresar" class="btn" title="click para ingresar" type="submit" value="RESTABLECER">
                
            </form>


        </div>
    </div>
    <script type="text/javascript" src="<?php echo e(asset('inicio/js/main.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('inicio/js/main2.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('bootstrap4/js/jquery.min.js')); ?>"></script>

    <script type="text/javascript" src="<?php echo e(asset('bootstrap4/js/bootstrap.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('bootstrap4/js/bootstrap.bundle.js')); ?>"></script>
    <script>
        // Selecciona el botón y el formulario
        const btnMostrar = document.querySelector("#mostrar-formulario");
        const formulario = document.querySelector("#mi-formulario");

        // Agrega un evento click al botón
        btnMostrar.addEventListener("click", function() {
            // Muestra el formulario
            formulario.style.display = "block";
        });
    </script>
</body>

</html>
<?php /**PATH C:\laragon\www\sis_apafa\resources\views/auth/loginRecuperar.blade.php ENDPATH**/ ?>