
<?php $__env->startSection('titulo', 'Reuniones'); ?>
<?php $__env->startSection('content'); ?>

    <style>
        .titulo {
            font-size: 20px;
            text-align: center;
            background: rgba(0, 0, 0, 0.464);
            padding: 10px;
            font-weight: bold;
            margin-bottom: 0;
        }

        .descripcion {
            color: rgb(255, 255, 255);
            font-weight: 500;
            background: rgba(0, 0, 0, 0.378);
            padding: 10px;
            margin-bottom: 0;
            /* text-shadow: 0px 0px 10px rgb(255, 255, 255)!important; */
        }

        .multa {
            background: rgb(171, 11, 11);
            padding: 7px;
            margin-bottom: 0;
        }

        .pie {
            display: flex;
            justify-content: space-between;
            height: auto !important;
            margin-bottom: 10px;
            background: rgba(0, 0, 0, 0.378) !important;
            font-size: 15px !important;
            padding-bottom: 20px;
        }

        .fecha {
            background: rgb(63, 91, 6);
            padding: 7px;
            color: rgb(255, 255, 255);
            font-weight: 600;
        }

        .card div {
            text-align: left;
            text-shadow: 2px 2px black 2px;
            font-size: 17px;
        }

        .card h5 {
            font-weight: bold;
        }

        .total {
            position: absolute;
            top: 0;
            left: 0;
            background: black;
            color: white;
            padding: 10px;
            font-weight: bold;
        }

        .estadoActivo .card-body {
            color: white;
        }

        .estadoInactivo {
            background: rgb(74, 74, 74);
        }

        .modal-body {
            height: 70vh;
            overflow: auto;
        }
    </style>
    


    <?php if(session('CORRECTO')): ?>
        <script>
            $(function notificacion() {
                new PNotify({
                    title: "CORRECTO",
                    type: "success",
                    text: "<?php echo e(session('CORRECTO')); ?>",
                    styling: "bootstrap3"
                });
            });
        </script>
    <?php endif; ?>

    <?php if(session('INCORRECTO')): ?>
        <script>
            $(function notificacion() {
                new PNotify({
                    title: "INCORRECTO",
                    type: "error",
                    text: "<?php echo e(session('INCORRECTO')); ?>",
                    styling: "bootstrap3"
                });
            });
        </script>
    <?php endif; ?>

    <h4 class="text-center text-secondary">LISTA DE REUNIONES</h4>

    <div class="pb-1 pt-2 d-flex flex-wrap gap-2">

        <a href="" data-toggle="modal" data-target="#registrar" class="btn btn-rounded btn-primary"><i
                class="fas fa-plus"></i>&nbsp;
            Nuevo registro</a>
    </div>

    <?php $__errorArgs = ['txtfile'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
        <p class="alert alert-danger p-2"><?php echo e($message); ?></p>
    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

    <!-- Modal registrar datos usuario-->
    <div class="modal fade" id="registrar" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header d-flex justify-content-between">
                    <h5 class="modal-title w-100" id="exampleModalLabel">Crear reunión</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form action="<?php echo e(route('reuniones.store')); ?>" method="POST">
                        <?php echo csrf_field(); ?>

                        <div class="mb-4 px-2 col-12">
                            <label>Titulo de la reunion *</label>
                            <input required type="text" placeholder="Ejemplo: Reunion general" class="input input__text"
                                name="txttitulo" value="<?php echo e(old('txttitulo')); ?>">
                            <?php $__errorArgs = ['txttitulo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="error-message text-danger p-2">Este campo es obligatorio</p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="fl-flex-label mb-4 px-2 col-12">
                            <textarea required name="txtdescripcion" class="input input__text" cols="10" rows="3"
                                placeholder="Descripcion de la reunión"></textarea>
                            <?php $__errorArgs = ['txtdescripcion'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="error-message text-danger p-2">Este campo es obligatorio</p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="mb-4 px-2 col-12">
                            <label>Multa *</label>
                            <input required type="number" placeholder="S/. 0.00" class="input input__text" name="txtmulta"
                                value="<?php echo e(old('txtmulta')); ?>">
                            <?php $__errorArgs = ['txtmulta'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="error-message text-danger p-2">Este campo es obligatorio</p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="mb-4 px-2 col-12">
                            <label>Fecha de la reunión *</label>
                            <input required type="date" class="input input__text" name="txtfecha" id="txtfecha"
                                value="<?php echo e(old('txtfecha')); ?>">
                            <?php $__errorArgs = ['txtfecha'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="error-message text-danger p-2">Este campo es obligatorio</p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="mb-4 px-2 col-12">
                            <label>Hora de la reunión *</label>
                            <input required type="time" class="input input__text" name="txthora"
                                value="<?php echo e(old('txthora')); ?>">
                            <?php $__errorArgs = ['txthora'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="error-message text-danger p-2">Este campo es obligatorio</p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="mb-4 px-2 col-12">
                            <label>Estado de la reunión *</label>
                            <select name="txtestado" class="input input__select">
                                <?php $__currentLoopData = $estado; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($item->id_estado_reunion); ?>"><?php echo e($item->estado); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>


                        <div class="text-right p-2">
                            <a data-dismiss="modal" class="btn btn-secondary btn-rounded">Atras</a>
                            <button type="submit" value="ok" name="btnmodificar"
                                class="btn btn-primary btn-rounded">Registrar</button>
                        </div>
                    </form>
                </div>

            </div>
        </div>
    </div>


    <section class="card">
        <div class="card-block">
            <div class="row">
                <?php $__currentLoopData = $reuniones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-lg-6 col-md-6 mb-1">
                        <div class="card">
                            <div
                                class="card-body statistic-box <?php echo e($item->id_estado_reunion == 1 ? 'green' : 'estadoInactivo'); ?>">
                                <p class="card-text titulo"><?php echo e($item->titulo); ?></p>
                                <p class="total"><?php echo e($item->total); ?> part.</p>
                                <p class="card-text descripcion"><?php echo e($item->descripcion); ?></p>
                                <div class="pie">
                                    <p class="card-text multa">Multa: S/. <?php echo e($item->multa_precio); ?>.00</p>
                                    <p class="card-text fecha">Fecha: <?php echo e($item->fecha); ?> - Hora: <?php echo e($item->hora); ?></p>
                                </div>
                                
                                
                                <a href="#" data-toggle="modal" data-target="#modificar<?php echo e($item->id_reunion); ?>"
                                    class="btn btn-warning"><i class="fas fa-edit"></i></a>
                                <form action="<?php echo e(route('reuniones.destroy', $item->id_reunion)); ?>" method="POST"
                                    class="d-inline formulario-eliminar">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('delete'); ?>
                                </form>
                                <a href="#" class="btn btn-danger eliminar" data-id="<?php echo e($item->id_reunion); ?>">
                                    <i class="fas fa-trash-alt"></i>
                                </a>

                                
                                <a href="<?php echo e(route('reuniones.reunionesReporteExcel', $item->id_reunion)); ?>"
                                    class="btn btn-success"><i class="fas fa-file-excel"> Excel</i></a>

                                <a href="<?php echo e(route('reuniones.reporte', $item->id_reunion)); ?>" target="_blank" class="btn btn-danger"><i
                                        class="fas fa-file-pdf"></i> PDF</a>


                                
                                <a href="<?php echo e(route('reuniones.vistaAgregarParticipante', $item->id_reunion)); ?>"
                                    class="btn bg-primary"><i class="fas fa-user-plus"></i> Agregar participantes</a>

                            </div>
                        </div>
                    </div>

                    <!-- Modal modificar datos usuario-->
                    <div class="modal fade" id="modificar<?php echo e($item->id_reunion); ?>" tabindex="-1"
                        aria-labelledby="exampleModalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header d-flex justify-content-between">
                                    <h5 class="modal-title w-100" id="exampleModalLabel">Modificar datos de la reunión
                                    </h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form action="<?php echo e(route('reuniones.update', $item->id_reunion)); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('put'); ?>
                                        <div class="mb-4 px-2 col-12">
                                            <label>Titulo de la reunion *</label>
                                            <input required type="text" placeholder="Ejemplo: Reunion general"
                                                class="input input__text" name="txttitulo"
                                                value="<?php echo e(old('txttitulo', $item->titulo)); ?>">
                                            <?php $__errorArgs = ['txttitulo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p class="error-message text-danger p-2">Este campo es obligatorio</p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <div class="fl-flex-label mb-4 px-2 col-12">
                                            <textarea required name="txtdescripcion" class="input input__text" cols="10" rows="3"
                                                placeholder="Descripcion de la reunión"><?php echo e(old('txtdescripcion', $item->descripcion)); ?></textarea>
                                            <?php $__errorArgs = ['txtdescripcion'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p class="error-message text-danger p-2">Este campo es obligatorio</p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <div class="mb-4 px-2 col-12">
                                            <label>Multa *</label>
                                            <input required type="number" placeholder="S/. 0.00"
                                                class="input input__text" name="txtmulta"
                                                value="<?php echo e(old('txtmulta', $item->multa_precio)); ?>">
                                            <?php $__errorArgs = ['txtmulta'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p class="error-message text-danger p-2">Este campo es obligatorio</p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <div class="mb-4 px-2 col-12">
                                            <label>Fecha de la reunión *</label>
                                            <input required type="date" class="input input__text" name="txtfecha"
                                                id="txtfecha" value="<?php echo e(old('txtfecha', $item->fecha)); ?>">
                                            <?php $__errorArgs = ['txtfecha'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p class="error-message text-danger p-2">Este campo es obligatorio</p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <div class="mb-4 px-2 col-12">
                                            <label>Hora de la reunión *</label>
                                            <input required type="time" class="input input__text" name="txthora"
                                                value="<?php echo e(old('txthora', $item->hora)); ?>">
                                            <?php $__errorArgs = ['txthora'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p class="error-message text-danger p-2">Este campo es obligatorio</p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <div class="mb-4 px-2 col-12">
                                            <label>Estado de la reunión *</label>
                                            <select name="txtestado" class="input input__select">
                                                <?php $__currentLoopData = $estado; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item2): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option
                                                        <?php echo e($item->id_estado_reunion == $item2->id_estado_reunion ? 'selected' : ''); ?>

                                                        value="<?php echo e($item2->id_estado_reunion); ?>"><?php echo e($item2->estado); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <div class="text-right p-2">
                                            <a data-dismiss="modal" class="btn btn-secondary btn-rounded">Atras</a>
                                            <button type="submit" value="ok" name="btnmodificar"
                                                class="btn btn-primary btn-rounded">Modificar</button>
                                        </div>
                                    </form>
                                </div>

                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>


            <div class="text-right">
                <?php echo e($reuniones->links('pagination::bootstrap-4')); ?>

                Mostrando <?php echo e($reuniones->firstItem()); ?> - <?php echo e($reuniones->lastItem()); ?> de
                <?php echo e($reuniones->total()); ?>

                resultados
            </div>

        </div>
    </section>


    <script>
        function confimar_eliminar() {
            let res = confirm('¿Estas seguro de eliminar todos los registros?');
            if (res) {
                return confirm(
                    'Por tu seguridad te preguntamos nuevamente. ¿Estas seguro de eliminar todos los registros?'
                );
            } else {
                return res;
            }
        }

        //bloquear dias menores al dia actual en input txtfecha
        // Obtener la fecha actual
        var fechaActual = new Date().toISOString().split('T')[0];

        // Obtener el campo de fecha
        var txtFecha = document.getElementById('txtfecha');

        // Establecer la fecha mínima en el campo de fecha
        txtFecha.min = fechaActual;
    </script>




<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\sis_apafa\resources\views/vistas/reuniones/index.blade.php ENDPATH**/ ?>