<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">

    <link rel="stylesheet" href="<?php echo e(asset('bootstrap4/css/bootstrap.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('inicio/css/style.css')); ?>">
    <link href="https://fonts.googleapis.com/css?family=Poppins:600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('fontawesome/css/all.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('fontawesome/css/fontawesome.min.css')); ?>">
    <link href="https://tresplazas.com/web/img/big_punto_de_venta.png" rel="shortcut icon">
    <title>Inicio de sesión</title>
    
    <link href="<?php echo e(asset('pnotify/css/pnotify.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('pnotify/css/pnotify.buttons.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('pnotify/css/custom.min.css')); ?>" rel="stylesheet" />

    
    <script src="<?php echo e(asset('pnotify/js/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('pnotify/js/pnotify.js')); ?>"></script>
    <script src="<?php echo e(asset('pnotify/js/pnotify.buttons.js')); ?>"></script>
</head>

<body>

    <?php if(session('CORRECTO')): ?>
        <script>
            $(function notificacion() {
                new PNotify({
                    title: "CORRECTO",
                    type: "success",
                    text: "<?php echo e(session('CORRECTO')); ?>",
                    styling: "bootstrap3"
                });
            });
        </script>
    <?php endif; ?>


    <?php if(session('INCORRECTO')): ?>
        <script>
            $(function notificacion() {
                new PNotify({
                    title: "INCORRECTO",
                    type: "error",
                    text: "<?php echo e(session('INCORRECTO')); ?>",
                    styling: "bootstrap3"
                });
            });
        </script>
    <?php endif; ?>

    <img class="wave" src="<?php echo e(asset('inicio/img/wave.png')); ?>">
    <div class="container">
        <div class="img">
            <img src="<?php echo e(asset('inicio/img/bg.svg')); ?>">
        </div>
        <div class="login-content">
            <form method="POST" action="<?php echo e(route('login')); ?>">
                <?php echo csrf_field(); ?>
                <img src="<?php echo e(asset('inicio/img/avatar.svg')); ?>">
                <h2 class="title">BIENVENIDO</h2>
                <?php if(session('mensaje')): ?>
                    <div class="alert alert-warning alert-dismissible fade show mb-0" role="alert">
                        <small><?php echo e(session('mensaje')); ?></small>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                <?php endif; ?>
                <div class="mb-3">

                    <?php $__errorArgs = ['usuario'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="alert alert-danger alert-dismissible fade show mb-1" role="alert">
                            <small><?php echo e($errors->first('usuario')); ?></small>
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>


                    <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="alert alert-danger alert-dismissible fade show mb-2" role="alert">
                            <small><?php echo e($errors->first('password')); ?></small>
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                </div>
                <div class="input-div one">
                    <div class="i">
                        <i class="fas fa-user"></i>
                    </div>
                    <div class="div">
                        <h5>Usuario</h5>
                        <input id="usuario" type="text"
                            class="input <?php $__errorArgs = ['usuario'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="usuario"
                            title="ingrese su nombre de usuario" autocomplete="usuario" value="<?php echo e(old('usuario')); ?>">


                    </div>
                </div>
                <div class="input-div pass">
                    <div class="i">
                        <i class="fas fa-lock"></i>
                    </div>
                    <div class="div">
                        <h5>Contraseña</h5>
                        <input type="password" id="input" class="input <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                            name="password" title="ingrese su clave para ingresar" autocomplete="current-password">


                    </div>
                </div>
                <div class="view">
                    <div class="fas fa-eye verPassword" onclick="vista()" id="verPassword"></div>
                </div>


                <div class="text-center">
                    <a class="font-italic isai5" href="<?php echo e(route('recuperar.index')); ?>">Olvidé mi contraseña</a>
                    <a class="font-italic isai5" href="<?php echo e(url('/')); ?>">Volver a la página principal</a>
                </div>
                <input name="btningresar" class="btn" title="click para ingresar" type="submit"
                    value="INICIAR SESION">
                
            </form>
        </div>
    </div>
    <script type="text/javascript" src="<?php echo e(asset('inicio/js/main.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('inicio/js/main2.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('bootstrap4/js/jquery.min.js')); ?>"></script>

    <script type="text/javascript" src="<?php echo e(asset('bootstrap4/js/bootstrap.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('bootstrap4/js/bootstrap.bundle.js')); ?>"></script>

</body>

</html>
<?php /**PATH C:\laragon\www\sis_apafa\resources\views/auth/login.blade.php ENDPATH**/ ?>