
<?php $__env->startSection('titulo', 'Lista de padres de familia'); ?>
<?php $__env->startSection('content'); ?>


    


    <?php if(session('CORRECTO')): ?>
        <script>
            $(function notificacion() {
                new PNotify({
                    title: "CORRECTO",
                    type: "success",
                    text: "<?php echo e(session('CORRECTO')); ?>",
                    styling: "bootstrap3"
                });
            });
        </script>
    <?php endif; ?>

    <?php if(session('INCORRECTO')): ?>
        <script>
            $(function notificacion() {
                new PNotify({
                    title: "INCORRECTO",
                    type: "error",
                    text: "<?php echo e(session('INCORRECTO')); ?>",
                    styling: "bootstrap3"
                });
            });
        </script>
    <?php endif; ?>

    <h4 class="text-center text-secondary">LISTA DE LOS PADRES DE FAMILIA</h4>

    <form action="#" id="formBuscar">
        <div class="form-group row col-12 px-4">
            <div class="col-12 col-sm-9">
                <input type="text" id="dni" class="form-control p-3"
                    placeholder="Ingrese el DNI o nombre del padre de familia" name="txtdni">
            </div>
            <button id="buscar" class="btn btn-success col-12 col-sm-3 mt-2 mt-sm-0" type="submit">Buscar</button>
        </div>
    </form>
    <div class="card-block table-responsive">
        <table id="" class="display table table-striped" cellspacing="0" width="100%">
            <thead class="table-primary">
                <tr>
                    <th>Id</th>
                    <th>Cargo</th>
                    <th>Tipo consanguinidad</th>
                    <th>DNI</th>
                    <th>Nombres</th>
                    <th>Apellido Paterno</th>
                    <th>Apellido Materno</th>
                    <th>Celular</th>
                    <th>Direccion</th>
                    <th></th>
                </tr>
            </thead>

            <tbody id="tbody">

            </tbody>
        </table>
    </div>


    <div class="pb-1 pt-2 d-flex flex-wrap gap-2">

        

        <a href="<?php echo e(route('padres-familia.create')); ?>" class="btn btn-rounded btn-primary"><i class="fas fa-plus"></i>&nbsp;
            Registro de padres</a>

        <a href="<?php echo e(route('padres-familia.exportarPadresFamilia')); ?>" class="btn btn-rounded btn-success"><i
                class="fas fa-file-excel"></i>&nbsp;
            Exportar a Excel</a>

        <a href="<?php echo e(route('padres-familia.vacearRegistro')); ?>" onclick="return confimar_eliminar()"
            class="btn btn-rounded btn-danger"><i class="fas fa-trash-alt"></i>&nbsp;
            Eliminar todos los registros</a>
        <a href="<?php echo e(route('padres-familia.descargarTarjeta', ['pagina' => $datosPadreFamilia->currentPage()])); ?>" target="_blank" class="btn btn-rounded btn-secondary"><i class="fas fa-file-pdf"></i>&nbsp;
            Descargar tarjeta de Pag <?php echo e($datosPadreFamilia->firstItem()); ?> - <?php echo e($datosPadreFamilia->lastItem()); ?> </a>
    </div>

    <?php $__errorArgs = ['txtfile'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
        <p class="alert alert-danger p-2"><?php echo e($message); ?></p>
    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>


    <?php if(session('AVISO')): ?>
        <div class="alert bg-danger mb-1">
            <?php echo e(session('AVISO')); ?>

        </div>
    <?php endif; ?>

    <section class="card">
        <div class="card-block">
            <table id="example2" class="display table table-striped" cellspacing="0" width="100%">
                <thead class="table-primary">
                    <tr>
                        <th>Id</th>
                        <th>DNI</th>
                        <th>Cargo</th>
                        <th>Tipo consanguinidad</th>
                        <th>Nombres</th>
                        <th>Apellido Paterno</th>
                        <th>Apellido Materno</th>
                        <th>Celular</th>
                        <th>Direccion</th>
                        <th></th>
                    </tr>
                </thead>

                <tbody>
                    <?php $__currentLoopData = $datosPadreFamilia; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>

                            <td><?php echo e($item->id_padre_familia); ?></td>
                            <td><?php echo e($item->padre_dni); ?></td>
                            <td><?php echo e($item->cargo); ?></td>
                            <td><?php echo e($item->tipo_consanguinidad); ?></td>
                            <td><?php echo e($item->padre_nombres); ?></td>
                            <td><?php echo e($item->padre_ape_pat); ?></td>
                            <td><?php echo e($item->padre_ape_mat); ?></td>
                            <td><?php echo e($item->celular); ?></td>
                            <td><?php echo e($item->direccion); ?></td>


                            <td>
                                <a style="top: 0" href="<?php echo e(route('padres-familia.show', $item->id_padre_familia)); ?>"
                                    class="btn btn-sm btn-warning m-1"><i class="fas fa-edit"></i></a>

                                <form action="<?php echo e(route('padres-familia.destroy', $item->id_padre_familia)); ?>"
                                    method="POST" class="d-inline formulario-eliminar">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('delete'); ?>
                                </form>
                                <a href="#" class="btn btn-sm btn-danger eliminar"
                                    data-id="<?php echo e($item->id_padre_familia); ?>">
                                    <i class="fas fa-trash-alt"></i>
                                </a>
                                <a style="top: 0" target="_blank"
                                    href="<?php echo e(route('padres-familia.tarjeta', $item->id_padre_familia)); ?>"
                                    class="btn btn-sm bg-primary m-1" title="Generar tarjeta"><i
                                        class="fas fa-address-card"></i></a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
            <div class="text-right">
                <?php echo e($datosPadreFamilia->links('pagination::bootstrap-4')); ?>

                Mostrando <?php echo e($datosPadreFamilia->firstItem()); ?> - <?php echo e($datosPadreFamilia->lastItem()); ?> de
                <?php echo e($datosPadreFamilia->total()); ?>

                resultados
            </div>

        </div>
    </section>


    <script>
        function confimar_eliminar() {
            let res = confirm('¿Estas seguro de eliminar todos los registros?');
            if (res) {
                return confirm(
                    'Por tu seguridad te preguntamos nuevamente. ¿Estas seguro de eliminar todos los registros?'
                );
            } else {
                return res;
            }
        }


        //enviando datos para la busqueda por ajax
        let formBuscar = document.getElementById("formBuscar");
        let dni = document.getElementById("dni");
        formBuscar.addEventListener("submit", buscarDatos);
        formBuscar.addEventListener("blur", buscarDatos);
        formBuscar.addEventListener("keyup", buscarDatos);
        //dni.addEventListener("blur", buscarDatos);
        //dni.addEventListener("keyup", buscarDatos);

        function buscarDatos(ev) {
            ev.preventDefault();
            let datos = $(this).serialize();
            $.ajax({
                url: "<?php echo e(route('padres-familia.buscarPadreFamilia')); ?>",
                type: "post",
                data: datos,
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    console.log("Hola correcto " + response.data)
                    let tbody = document.getElementById("tbody")
                    let tr = "";
                    response.data.forEach(function(item, index) {
                        tr +=
                            `
                        <tr>
                            <td>${item.id_padre_familia}</td>
                            <td>${item.cargo}</td>
                            <td>${item.tipo_consanguinidad}</td>
                            <td>${item.padre_dni}</td>
                            <td>${item.padre_nombres}</td>
                            <td>${item.padre_ape_pat}</td>
                            <td>${item.padre_ape_mat}</td>
                            <td>${item.celular}</td>
                            <td>${item.direccion}</td>
                            <td>
                                <a style="top: 0" href="padres-familia/${item.id_padre_familia}" class="btn btn-sm btn-primary m-1"><i class="fas fa-eye"></i></a>
                                <a style="top: 0" href="padres-familia-tarjeta-${item.id_padre_familia}" target="_blank" class="btn btn-sm bg-primary m-1"title="Generar tarjeta"><i class="fas fa-address-card"></i></a>
                            </td>
                        </tr>
                        `
                    });
                    tbody.innerHTML = tr
                },
                error: function(error) {
                    let tbody = document.getElementById("tbody")
                    tbody.innerHTML = ""
                }
            });
        }
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\SISTEMAS-INFORMACION\sis_apafa\resources\views/vistas/padres_familia/index.blade.php ENDPATH**/ ?>