<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Historial de Padres</title>
    <style>
        body {
            font-family: 'Helvetica', 'Arial', sans-serif;
            font-size: 11px;
            line-height: 1.4;
            color: #333;
            margin: 0;
            padding: 0;
            background-color: #fff;
        }

        .page-header {
            text-align: center;
            margin-bottom: 20px;
            padding: 15px;
            background: #313d48;
        }

        .header-title {
            font-size: 17px;
            font-weight: bold;
            color: #e7ecf1;
            text-transform: uppercase;
            margin: 0;
        }

        .padre-info {
            background: linear-gradient(135deg, #00897B 0%, #009688 100%);
            color: white;
            padding: 15px;
            margin-bottom: 15px;
            border-radius: 5px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
        }

        .padre-card {
            display: flex;
            flex-wrap: wrap;
            justify-content: space-between;
        }

        .padre-detail {
            width: 48%;
            margin-bottom: 8px;
            color
        }

        .detail-label {
            font-weight: bold;
            display: block;
            font-size: 10px;
            text-transform: uppercase;
            margin-bottom: 2px;
            color: rgba(255, 255, 255, 0.85);
        }

        .detail-value {
            font-size: 11px;
            font-weight: bold;
        }

        .hijos-info {
            background: #f5f5f5;
            border: 1px solid #e0e0e0;
            border-radius: 5px;
            padding: 10px 15px;
            margin-bottom: 20px;
        }

        .hijos-title {
            font-size: 12px;
            font-weight: bold;
            color: #1976D2;
            margin-bottom: 8px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .hijo-item {
            background: white;
            padding: 8px 10px;
            border-radius: 3px;
            margin-bottom: 5px;
            border-left: 3px solid #1976D2;
            font-size: 10px;
        }

        .hijo-name {
            font-weight: bold;
        }

        .section {
            margin-bottom: 25px;
        }

        .section-header {
            background: #52616e;
            color: white;
            padding: 8px;
            text-align: center;
            font-size: 12px;
            font-weight: bold;
            border-radius: 5px 5px 0 0;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 10px;
            border: 1px solid #e0e0e0;
            box-shadow: 0 1px 4px rgba(0, 0, 0, 0.08);
        }

        table th {
            background-color: #f5f5f5;
            color: #424242;
            padding: 4px;
            text-align: left;
            font-weight: bold;
            border: 1px solid #e0e0e0;
        }

        table td {
            padding: 4px 4px;
            border: 1px solid #e0e0e0;
            vertical-align: middle;
        }

        table tr:nth-child(even) {
            background-color: #f9f9f9;
        }

        .badge {
            padding: 4px 8px;
            border-radius: 3px;
            font-size: 9px;
            font-weight: bold;
            display: inline-block;
            text-align: center;
        }

        .badge-danger {
            background-color: #ffebee;
            color: #d32f2f;
            border: 1px solid #ffcdd2;
        }

        .badge-success {
            background-color: #e8f5e9;
            color: #2e7d32;
            border: 1px solid #c8e6c9;
        }

        .amount {
            font-weight: bold;
            padding: 4px 7px;
            border-radius: 3px;
            font-size: 10px;
            text-align: right;
            display: inline-block;
        }

        .amount-debt {
            background-color: #263238;
            color: white;
        }

        .amount-paid {
            background-color: #d3e7d3;
            color: rgb(32, 94, 19);
        }

        .amount-fine {
            background-color: #e3c9c9;
            color: rgb(90, 21, 21);
        }

        .text-center {
            text-align: center;
        }

        .text-right {
            text-align: right;
        }

        .table-narrow {
            width: 70px;
        }

        .footer {
            text-align: center;
            margin-top: 30px;
            font-size: 9px;
            color: #757575;
            border-top: 1px solid #e0e0e0;
            padding-top: 10px;
        }

        .page-number:after {
            content: "Página " counter(page);
        }
    </style>
</head>

<body>
    <div class="page-header">
        <h1 class="header-title">Reporte de Historial de Padre de Familia</h1>
    </div>

    <div class="section">
        <div class="section-header">Información del Padre de Familia</div>
        <table>
            <tbody>
                <tr>
                    <th width="30%">Nombre Completo</th>
                    <td><?php echo e($datosPadre[0]->nombre); ?></td>
                </tr>
                <tr>
                    <th>DNI</th>
                    <td><?php echo e($datosPadre[0]->padre_dni); ?></td>
                </tr>
                <tr>
                    <th>Celular</th>
                    <td><?php echo e($datosPadre[0]->celular ?? 'No registrado'); ?></td>
                </tr>
                <tr>
                    <th>Dirección</th>
                    <td><?php echo e($datosPadre[0]->direccion ?? 'No registrada'); ?></td>
                </tr>
                <tr>
                    <th>Tipo de Consanguinidad</th>
                    <td><?php echo e($datosPadre[0]->tipo_consanguinidad ?? 'No especificado'); ?></td>
                </tr>

            </tbody>
        </table>
    </div>

    <div class="section">
        <div class="section-header">Información de Hijos (<?php echo e($cantidadHijos); ?>)</div>
        <table>
            <thead>
                <tr>
                    <th width="5%">N°</th>
                    <th width="35%">Nombre Completo</th>
                    <th width="15%">DNI</th>
                    <th width="20%">Nivel</th>
                    <th width="25%">Grado</th>
                </tr>
            </thead>
            <tbody>
                <?php if(isset($hijos) && count($hijos) > 0): ?>
                    <?php $__currentLoopData = $hijos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $hijo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td class="text-center"><?php echo e($key + 1); ?></td>
                            <td><?php echo e($hijo->nombre_completo); ?></td>
                            <td><?php echo e($hijo->dni ?? 'No registrado'); ?></td>
                            <td><?php echo e($hijo->nivel); ?></td>
                            <td><?php echo e($hijo->grado); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <tr>
                        <td colspan="5" class="text-center">No hay información de hijos registrada.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    <div class="section">
        <div class="section-header">Aportes</div>
        <table>
            <thead>
                <tr>
                    <th width="5%">N°</th>
                    <th width="15%">Título</th>
                    <th width="20%">Descripción</th>
                    <th width="15%">Monto a aportar</th>
                    <th width="12%">Monto aportado</th>
                    <th width="12%">Monto pendiente</th>
                    <th width="10%">Fecha plazo</th>
                    <th width="10%">Estado</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $historialAportes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td class="text-center"><?php echo e($key + 1); ?></td>
                        <td><?php echo e($item->titulo); ?></td>
                        <td><?php echo e($item->descripcion); ?></td>
                        <td><?php echo e($item->monto); ?> <b> X <?php echo e($cantidadHijos); ?> hijos = S/. <?php echo e($item->monto_aporte); ?></b>
                        </td>
                        <td class="text-center"><span class="amount amount-paid">S/. <?php echo e($item->monto_aportado); ?></span>
                        </td>
                        <td class="text-center"><span class="amount amount-debt">S/. <?php echo e($item->debe); ?></span></td>
                        <td class="text-center"><?php echo e(date('d/m/Y', strtotime($item->fecha))); ?></td>
                        <td class="text-center">
                            <?php if($item->debe == null || $item->debe > 0): ?>
                                <span class="badge badge-danger">Pendiente</span>
                            <?php else: ?>
                                <span class="badge badge-success">Pagado</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>

    <div class="section">
        <div class="section-header">Reuniones</div>
        <table>
            <thead>
                <tr>
                    <th width="5%">N°</th>
                    <th width="20%">Título</th>
                    <th width="25%">Descripción</th>
                    <th width="10%">Multa</th>
                    <th width="20%">Fecha y hora</th>
                    <th width="20%">Asistencia</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $historialReuniones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td class="text-center"><?php echo e($key + 1); ?></td>
                        <td><?php echo e($item->titulo); ?></td>
                        <td><?php echo e($item->descripcion); ?></td>
                        <td class="text-center"><span class="amount amount-fine">S/. <?php echo e($item->multa_precio); ?></span>
                        </td>
                        <td class="text-center"><?php echo e(date('d/m/Y', strtotime($item->fecha))); ?> <?php echo e($item->hora); ?></td>
                        <td class="text-center">
                            <?php if($item->asistencia == null): ?>
                                <span class="badge badge-danger">No asistió</span>
                            <?php else: ?>
                                <span class="badge badge-success">Asistió</span>
                                <?php if($item->asistencia_salida): ?>
                                    <br><small>Entrada: <?php echo e(date('H:i', strtotime($item->asistencia))); ?></small>
                                    <br><small>Salida: <?php echo e(date('H:i', strtotime($item->asistencia_salida))); ?></small>
                                <?php endif; ?>
                            <?php endif; ?>
                            <?php if($item->detalles): ?>
                                <br><small><?php echo e($item->detalles); ?></small>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>

    <div class="section">
        <div class="section-header">Pagos registrados</div>
        <table>
            <thead>
                <tr>
                    <th width="5%">N°</th>
                    <th width="20%">Registrado por</th>
                    <th width="10%">Fecha</th>
                    <th width="25%">Pago por concepto</th>
                    <th width="10%">Fecha pago</th>
                    <th width="15%">N° recibo</th>
                    <th width="15%">Monto</th>
                    <th width="15%">Estado</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $historialPagos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td class="text-center"><?php echo e($key + 1); ?></td>
                        <td><?php echo e($item->nombres); ?></td>
                        <td><?php echo e(date('d/m/Y', strtotime($item->fecha))); ?></td>
                        <td><?php echo e($item->pago_concepto); ?></td>
                        <td><?php echo e($item->fecha_pago_boucher ? date('d/m/Y', strtotime($item->fecha_pago_boucher)) : 'N/A'); ?>

                        </td>
                        <td><?php echo e($item->numero_pago_boucher ?? 'N/A'); ?></td>
                        <td class="text-center"><span class="amount amount-paid">S/. <?php echo e($item->monto_pago); ?></span>
                        </td>
                        
                        <td class="text-center">
                            <?php if($item->estado == 'VIGENTE'): ?>
                                <span class="badge badge-success">Vigente</span>
                            <?php elseif($item->estado == 'EDITADO'): ?>
                                <span class="badge badge-warning">Editado</span>
                            <?php elseif($item->estado == 'ANULADO'): ?>
                                <span class="badge badge-danger">Anulado</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>

    <div class="footer">
        <p>Documento generado el <?php echo e(date('d/m/Y H:i:s')); ?> | <span class="page-number"></span></p>
    </div>
</body>

</html>
<?php /**PATH C:\laragon\www\SISTEMAS-INFORMACION\sis_apafa\resources\views/vistas/historial/historialPDF.blade.php ENDPATH**/ ?>