
<?php $__env->startSection('titulo', 'Aportes'); ?>
<?php $__env->startSection('content'); ?>

    <style>
        .titulo {
            font-size: 20px;
            text-align: center;
            background: rgba(0, 0, 0, 0.464);
            padding: 10px;
            font-weight: bold;
            margin-bottom: 0;
        }

        .descripcion {
            color: rgb(255, 255, 255);
            font-weight: 500;
            background: rgba(0, 0, 0, 0.378);
            padding: 10px;
            margin-bottom: 0;
            /* text-shadow: 0px 0px 10px rgb(255, 255, 255)!important; */
        }

        .multa {
            background: rgb(171, 11, 11);
            padding: 7px;
            margin-bottom: 0;
        }

        .pie {
            display: flex;
            justify-content: space-between;
            height: auto !important;
            margin-bottom: 10px;
            background: rgba(0, 0, 0, 0.378) !important;
            font-size: 15px !important;
            padding-bottom: 20px;
        }

        .fecha {
            background: rgb(63, 91, 6);
            padding: 7px;
            color: rgb(255, 255, 255);
            font-weight: 600;
        }

        .card div {
            text-align: left;
            text-shadow: 2px 2px black 2px;
            font-size: 17px;
        }

        .card h5 {
            font-weight: bold;
        }

        .total {
            position: absolute;
            top: 0;
            left: 0;
            background: black;
            color: white;
            padding: 10px;
            font-weight: bold;
        }

        .estadoActivo .card-body {
            color: white;
        }

        .estadoInactivo {
            background: rgb(74, 74, 74);
        }

        .modal-body {
            overflow: auto;
        }

        textarea {
            field-sizing: content;
        }
    </style>
    


    <?php if(session('CORRECTO')): ?>
        <script>
            $(function notificacion() {
                new PNotify({
                    title: "CORRECTO",
                    type: "success",
                    text: "<?php echo e(session('CORRECTO')); ?>",
                    styling: "bootstrap3"
                });
            });
        </script>
    <?php endif; ?>



    <?php if(session('INCORRECTO')): ?>
        <script>
            $(function notificacion() {
                new PNotify({
                    title: "INCORRECTO",
                    type: "error",
                    text: "<?php echo e(session('INCORRECTO')); ?>",
                    styling: "bootstrap3"
                });
            });
        </script>
    <?php endif; ?>

    <h4 class="text-center text-secondary">LISTA DE APORTES</h4>

    <div class="pb-1 pt-2 d-flex flex-wrap gap-2">

        <a href="" data-toggle="modal" data-target="#registrar" class="btn btn-rounded btn-primary"><i
                class="fas fa-plus"></i>&nbsp;
            Nuevo registro</a>
    </div>

    <?php $__errorArgs = ['txtfile'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
        <p class="alert alert-danger p-2"><?php echo e($message); ?></p>
    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

    <!-- Modal registrar datos aportes-->
    <div class="modal fade" id="registrar" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header d-flex justify-content-between">
                    <h5 class="modal-title w-100" id="exampleModalLabel">Crear nuevo Aporte</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form action="<?php echo e(route('aportes.store')); ?>" method="POST">
                        <?php echo csrf_field(); ?>

                        <div class="mb-4 px-2 col-12">
                            <label>Titulo *</label>
                            <input required type="text" placeholder="Ejemplo: Aporte para el techado de la IE"
                                class="input input__text" name="txttitulo" value="<?php echo e(old('txttitulo')); ?>">
                            <?php $__errorArgs = ['txttitulo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="error-message text-danger p-2">Este campo es obligatorio</p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="fl-flex-label mb-4 px-2 col-12">
                            <textarea required name="txtdescripcion" class="input input__text" cols="10" rows="3"
                                placeholder="Descripcion de la reunión"></textarea>
                            <?php $__errorArgs = ['txtdescripcion'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="error-message text-danger p-2">Este campo es obligatorio</p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="mb-4 px-2 col-12">
                            <label>Monto *</label>
                            <input required type="number" placeholder="S/. 0.00" class="input input__text" name="txtmonto"
                                value="<?php echo e(old('txtmonto')); ?>">
                            <?php $__errorArgs = ['txtmonto'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="error-message text-danger p-2">Este campo es obligatorio</p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="mb-4 px-2 col-12">
                            <label>Fecha plazo *</label>
                            <input required type="date" class="input input__text" name="txtfecha" id="txtfecha"
                                value="<?php echo e(old('txtfecha')); ?>">
                            <?php $__errorArgs = ['txtfecha'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="error-message text-danger p-2">Este campo es obligatorio</p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="mb-4 px-2 col-12">
                            <label for="mult">
                                <input type="checkbox" name="multiplicar" id="mult" checked>
                                Multiplicar aporte por cantidad de hijos ?
                            </label>
                        </div>


                        <div class="text-right p-2">
                            <a data-dismiss="modal" class="btn btn-secondary btn-rounded">Atras</a>
                            <button type="submit" value="ok" name="btnmodificar"
                                class="btn btn-primary btn-rounded">Registrar</button>
                        </div>
                    </form>
                </div>

            </div>
        </div>
    </div>


    <section class="card">
        <div class="card-block">
            <div class="row">
                <?php $__currentLoopData = $aportes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-lg-6 col-md-6 mb-1">
                        <div class="card">
                            <div class="card-body statistic-box bg-info">
                                <p class="card-text titulo"><?php echo e($item->titulo); ?></p>
                                <p class="total"><?php echo e($item->total); ?> aport.</p>
                                <p class="card-text descripcion"><?php echo e($item->descripcion); ?></p>
                                <div class="pie">
                                    <p class="card-text multa">Multa: S/. <?php echo e($item->monto); ?>.00</p>
                                    <p class="card-text fecha">Fecha: <?php echo e($item->fecha); ?> - Hora: <?php echo e($item->hora); ?></p>
                                </div>
                                <a href="#" data-toggle="modal" data-target="#modificar<?php echo e($item->id_aporte); ?>"
                                    class="btn btn-warning"><i class="fas fa-edit"></i></a>
                                <form action="<?php echo e(route('aportes.destroy', $item->id_aporte)); ?>" method="POST"
                                    class="d-inline formulario-eliminar">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('delete'); ?>
                                </form>
                                <a href="#" class="btn btn-danger eliminar" data-id="<?php echo e($item->id_aporte); ?>">
                                    <i class="fas fa-trash-alt"></i>
                                </a>

                                <a href="<?php echo e(route('aportes.aportesReporteExcel', $item->id_aporte)); ?>"
                                    class="btn btn-success"><i class="fas fa-file-excel"></i> Excel</a>

                                <a href="<?php echo e(route('aportes.reporte', $item->id_aporte)); ?>" target="_blank"
                                    class="btn btn-danger"><i class="fas fa-file-pdf"></i> PDF</a>

                                <a href="<?php echo e(route('aportes.vistaAgregarParticipante', $item->id_aporte)); ?>"
                                    class="btn bg-primary"><i class="fas fa-user-plus"></i> Aportantes</a>
                                <a href="#" data-toggle="modal" data-target="#report<?php echo e($item->id_aporte); ?>"
                                    class="btn bg-dark"><i class="fas fa-file-invoice"></i> Rend. Cuenta</a>
                            </div>
                        </div>
                    </div>

                    <!-- Modal modificar datos APORTE-->
                    <div class="modal fade" id="modificar<?php echo e($item->id_aporte); ?>" tabindex="-1"
                        aria-labelledby="exampleModalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header d-flex justify-content-between">
                                    <h5 class="modal-title w-100" id="exampleModalLabel">Modificar datos del aporte
                                    </h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form action="<?php echo e(route('aportes.update', $item->id_aporte)); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('put'); ?>
                                        <div class="mb-4 px-2 col-12">
                                            <label>Titulo *</label>
                                            <input required type="text"
                                                placeholder="Ejemplo: Aporte para el techado de la IE"
                                                class="input input__text" name="txttitulo"
                                                value="<?php echo e(old('txttitulo', $item->titulo)); ?>">
                                            <?php $__errorArgs = ['txttitulo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p class="error-message text-danger p-2">Este campo es obligatorio</p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <div class="fl-flex-label mb-4 px-2 col-12">
                                            <textarea required name="txtdescripcion" class="input input__text" cols="10" rows="3"
                                                placeholder="Descripcion de la reunión"><?php echo e(old('txtdescripcion', $item->descripcion)); ?></textarea>
                                            <?php $__errorArgs = ['txtdescripcion'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p class="error-message text-danger p-2">Este campo es obligatorio</p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <div class="mb-4 px-2 col-12">
                                            <label>Monto *</label>
                                            <input required type="number" placeholder="S/. 0.00"
                                                class="input input__text" name="txtmonto"
                                                value="<?php echo e(old('txtmonto', $item->monto)); ?>">
                                            <?php $__errorArgs = ['txtmonto'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p class="error-message text-danger p-2">Este campo es obligatorio</p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <div class="mb-4 px-2 col-12">
                                            <label>Fecha plazo *</label>
                                            <input required type="date" class="input input__text" name="txtfecha"
                                                id="txtfecha" value="<?php echo e(old('txtfecha', $item->fechaAp)); ?>">
                                            <?php $__errorArgs = ['txtfecha'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <p class="error-message text-danger p-2">Este campo es obligatorio</p>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <div class="mb-4 px-2 col-12">
                                            <label for="mult">
                                                <input type="checkbox" id="mult" disabled
                                                    <?php echo e($item->multiplicar == 'on' ? 'checked' : ''); ?>>
                                                Multiplicar aporte por cantidad de hijos ?
                                            </label>
                                        </div>


                                        <div class="text-right p-2">
                                            <a data-dismiss="modal" class="btn btn-secondary btn-rounded">Cerrar</a>
                                            <button type="submit" value="ok" name="btnmodificar"
                                                class="btn btn-primary btn-rounded">Modificar</button>
                                        </div>
                                    </form>
                                </div>

                            </div>
                        </div>
                    </div>

                    <!-- Modal subir rendicion de cuentas-->
                    <div class="modal fade" id="report<?php echo e($item->id_aporte); ?>" tabindex="-1"
                        aria-labelledby="exampleModalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header d-flex justify-content-between">
                                    <h5 class="modal-title w-100" id="exampleModalLabel">Rendicion de cuentas
                                        "<?php echo e($item->titulo); ?>"
                                    </h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">

                                    <?php if($item->rendicion != null): ?>
                                        <a href="<?php echo e(asset("storage/ARCHIVOS/pagos/rendicion/$item->rendicion")); ?>"
                                            class="btn btn-secondary mb-2" target="_blank"
                                            download="Rendicion de cuenta <?php echo e($item->titulo); ?>"><i
                                                class="fas fa-download"></i> Descargar
                                            archivo de rendicion</a>
                                    <?php endif; ?>

                                    <form action="<?php echo e(route('aportes.rendicionCuenta')); ?>" method="POST"
                                        enctype="multipart/form-data">
                                        <?php echo csrf_field(); ?>

                                        <input type="hidden" name="id_aporte" value="<?php echo e($item->id_aporte); ?>">

                                        <div class="mb-4 px-2 col-12">
                                            <label>Seleccionar archivo de rendicion de cuenta *</label>
                                            <input required type="file" class="form-control mt-3" name="txtfile"
                                                id="txtfile" class="input input__text">
                                        </div>

                                        <div class="text-right p-2">
                                            <a data-dismiss="modal" class="btn btn-secondary btn-rounded">Cerrar</a>
                                            <button type="submit" value="ok" name="btnmodificar"
                                                class="btn btn-primary btn-rounded">Guardar</button>
                                        </div>
                                    </form>
                                </div>

                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>


            <div class="text-right">
                <?php echo e($aportes->links('pagination::bootstrap-4')); ?>

                Mostrando <?php echo e($aportes->firstItem()); ?> - <?php echo e($aportes->lastItem()); ?> de
                <?php echo e($aportes->total()); ?>

                resultados
            </div>

        </div>
    </section>


    <script>
        function confimar_eliminar() {
            let res = confirm('¿Estas seguro de eliminar todos los registros?');
            if (res) {
                return confirm(
                    'Por tu seguridad te preguntamos nuevamente. ¿Estas seguro de eliminar todos los registros?'
                );
            } else {
                return res;
            }
        }

        //bloquear dias menores al dia actual en input txtfecha
        // Obtener la fecha actual
        var fechaActual = new Date().toISOString().split('T')[0];

        // Obtener el campo de fecha
        var txtFecha = document.getElementById('txtfecha');

        // Establecer la fecha mínima en el campo de fecha
        txtFecha.min = fechaActual;
    </script>




<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\SISTEMAS-INFORMACION\sis_apafa\resources\views/vistas/aportes/index.blade.php ENDPATH**/ ?>